/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.command;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.seatunnel.core.starter.command.AbstractCommandArgs;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.exception.CommandExecuteException;
import org.apache.seatunnel.core.starter.exception.ConfigCheckException;
import org.apache.seatunnel.core.starter.utils.ConfigShadeUtils;
import org.apache.seatunnel.core.starter.utils.FileUtils;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigResolveOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfEncryptCommand
implements Command<AbstractCommandArgs> {
    private static final Logger log = LoggerFactory.getLogger(ConfEncryptCommand.class);
    private final AbstractCommandArgs abstractCommandArgs;

    public ConfEncryptCommand(AbstractCommandArgs abstractCommandArgs) {
        this.abstractCommandArgs = abstractCommandArgs;
    }

    @Override
    public void execute() throws CommandExecuteException, ConfigCheckException {
        if (this.abstractCommandArgs.isDecrypt()) {
            log.warn("When both --decrypt and --encrypt are specified, only --encrypt will take effect");
        }
        String encryptConfigFile = this.abstractCommandArgs.getConfigFile();
        Path configPath = Paths.get(encryptConfigFile, new String[0]);
        FileUtils.checkConfigExist(configPath);
        Config config = ConfigFactory.parseFile(configPath.toFile()).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true)).resolveWith(ConfigFactory.systemProperties(), ConfigResolveOptions.defaults().setAllowUnresolved(true));
        Config encryptConfig = ConfigShadeUtils.encryptConfig(config);
        log.info("Encrypt config: \n{}", (Object)encryptConfig.root().render(ConfigRenderOptions.defaults().setOriginComments(false)));
    }
}

