/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;

public final class Handover<T>
implements Closeable {
    private static final int DEFAULT_QUEUE_SIZE = 10000;
    private final Object lock = new Object();
    private final LinkedBlockingQueue<T> blockingQueue = new LinkedBlockingQueue(10000);
    private Throwable error;

    public boolean isEmpty() {
        return this.blockingQueue.isEmpty();
    }

    public Optional<T> pollNext() throws Exception {
        if (this.error != null) {
            Handover.rethrowException(this.error, this.error.getMessage());
        } else if (!this.isEmpty()) {
            return Optional.ofNullable(this.blockingQueue.poll());
        }
        return Optional.empty();
    }

    public void produce(T element) throws InterruptedException, ClosedException {
        if (this.error != null) {
            throw new ClosedException();
        }
        this.blockingQueue.put(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportError(Throwable t) {
        Preconditions.checkNotNull(t);
        Object object = this.lock;
        synchronized (object) {
            if (this.error == null) {
                this.error = t;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.error == null) {
                this.error = new ClosedException();
            }
            this.lock.notifyAll();
        }
    }

    public static void rethrowException(Throwable t, String parentMessage) throws Exception {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new Exception(parentMessage, t);
    }

    public static final class ClosedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

