/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.sink;

import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;

public class DefaultSaveModeHandler
implements SaveModeHandler {
    public SchemaSaveMode schemaSaveMode;
    public DataSaveMode dataSaveMode;
    public Catalog catalog;
    public TablePath tablePath;
    public CatalogTable catalogTable;
    public String customSql;

    public DefaultSaveModeHandler(SchemaSaveMode schemaSaveMode, DataSaveMode dataSaveMode, Catalog catalog, CatalogTable catalogTable, String customSql) {
        this(schemaSaveMode, dataSaveMode, catalog, catalogTable.getTableId().toTablePath(), catalogTable, customSql);
    }

    @Override
    public void handleSchemaSaveMode() {
        switch (this.schemaSaveMode) {
            case RECREATE_SCHEMA: {
                this.recreateSchema();
                break;
            }
            case CREATE_SCHEMA_WHEN_NOT_EXIST: {
                this.createSchemaWhenNotExist();
                break;
            }
            case ERROR_WHEN_SCHEMA_NOT_EXIST: {
                this.errorWhenSchemaNotExist();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported save mode: " + (Object)((Object)this.schemaSaveMode));
            }
        }
    }

    @Override
    public void handleDataSaveMode() {
        switch (this.dataSaveMode) {
            case DROP_DATA: {
                this.keepSchemaDropData();
                break;
            }
            case APPEND_DATA: {
                this.keepSchemaAndData();
                break;
            }
            case CUSTOM_PROCESSING: {
                this.customProcessing();
                break;
            }
            case ERROR_WHEN_DATA_EXISTS: {
                this.errorWhenDataExists();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported save mode: " + (Object)((Object)this.dataSaveMode));
            }
        }
    }

    protected void recreateSchema() {
        if (this.tableExists()) {
            this.dropTable();
        }
        this.createTable();
    }

    protected void createSchemaWhenNotExist() {
        if (!this.tableExists()) {
            this.createTable();
        }
    }

    protected void errorWhenSchemaNotExist() {
        if (!this.tableExists()) {
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.SINK_TABLE_NOT_EXIST, "The sink table not exist");
        }
    }

    protected void keepSchemaDropData() {
        if (this.tableExists()) {
            this.truncateTable();
        }
    }

    protected void keepSchemaAndData() {
    }

    protected void customProcessing() {
        this.executeCustomSql();
    }

    protected void errorWhenDataExists() {
        if (this.dataExists()) {
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.SOURCE_ALREADY_HAS_DATA, "The target data source already has data");
        }
    }

    protected boolean tableExists() {
        return this.catalog.tableExists(this.tablePath);
    }

    protected void dropTable() {
        this.catalog.dropTable(this.tablePath, true);
    }

    protected void createTable() {
        if (!this.catalog.databaseExists(this.tablePath.getDatabaseName())) {
            this.catalog.createDatabase(TablePath.of(this.tablePath.getDatabaseName(), ""), true);
        }
        this.catalog.createTable(this.tablePath, this.catalogTable, true);
    }

    protected void truncateTable() {
        this.catalog.truncateTable(this.tablePath, true);
    }

    protected boolean dataExists() {
        return this.catalog.isExistsData(this.tablePath);
    }

    protected void executeCustomSql() {
        this.catalog.executeSql(this.tablePath, this.customSql);
    }

    @Override
    public void close() throws Exception {
        this.catalog.close();
    }

    public DefaultSaveModeHandler(SchemaSaveMode schemaSaveMode, DataSaveMode dataSaveMode, Catalog catalog, TablePath tablePath, CatalogTable catalogTable, String customSql) {
        this.schemaSaveMode = schemaSaveMode;
        this.dataSaveMode = dataSaveMode;
        this.catalog = catalog;
        this.tablePath = tablePath;
        this.catalogTable = catalogTable;
        this.customSql = customSql;
    }
}

