/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.utils;

import com.hazelcast.internal.util.StringUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.core.starter.utils.ConfigBuilder;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class RestUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private RestUtil() {
    }

    public static JsonNode convertByteToJsonNode(byte[] byteData) throws IOException {
        return objectMapper.readTree(byteData);
    }

    public static void buildRequestParams(Map<String, String> requestParams, String uri) {
        requestParams.put("jobId", null);
        requestParams.put("jobName", "SeaTunnel");
        requestParams.put("isStartWithSavePoint", String.valueOf(false));
        uri = StringUtil.stripTrailingSlash(uri);
        if (!uri.contains("?")) {
            return;
        }
        int indexEnd = uri.indexOf(63);
        try {
            for (String s2 : uri.substring(indexEnd + 1).split("&")) {
                String[] param2 = s2.split("=");
                requestParams.put(param2[0], param2[1]);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid Params format in Params.");
        }
    }

    public static Config buildConfig(JsonNode jsonNode) {
        Map<String, Object> objectMap = JsonUtils.toMap(jsonNode);
        return ConfigBuilder.of(objectMap);
    }
}

