/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.rest;

import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpPostCommand;
import com.hazelcast.internal.ascii.rest.HttpStatusCode;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.serialization.Data;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.server.CoordinatorService;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.job.JobImmutableInformationEnv;
import org.apache.seatunnel.engine.server.log.Log4j2HttpPostCommandProcessor;
import org.apache.seatunnel.engine.server.utils.RestUtil;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class RestHttpPostCommandProcessor
extends HttpCommandProcessor<HttpPostCommand> {
    private final Log4j2HttpPostCommandProcessor original;

    public RestHttpPostCommandProcessor(TextCommandService textCommandService) {
        this(textCommandService, new Log4j2HttpPostCommandProcessor(textCommandService));
    }

    protected RestHttpPostCommandProcessor(TextCommandService textCommandService, Log4j2HttpPostCommandProcessor log4j2HttpPostCommandProcessor) {
        super(textCommandService, textCommandService.getNode().getLogger(Log4j2HttpPostCommandProcessor.class));
        this.original = log4j2HttpPostCommandProcessor;
    }

    @Override
    public void handle(HttpPostCommand httpPostCommand) {
        String uri = httpPostCommand.getURI();
        try {
            if (uri.startsWith("/hazelcast/rest/maps/submit-job")) {
                this.handleSubmitJob(httpPostCommand, uri);
            } else {
                this.original.handle(httpPostCommand);
            }
        }
        catch (IllegalArgumentException e) {
            this.prepareResponse(HttpStatusCode.SC_400, httpPostCommand, RestHttpPostCommandProcessor.exceptionResponse(e));
        }
        catch (Throwable e) {
            this.logger.warning("An error occurred while handling request " + httpPostCommand, e);
            this.prepareResponse(HttpStatusCode.SC_500, httpPostCommand, RestHttpPostCommandProcessor.exceptionResponse(e));
        }
        this.textCommandService.sendResponse(httpPostCommand);
    }

    private SeaTunnelServer getSeaTunnelServer() {
        Map<String, Object> extensionServices = this.textCommandService.getNode().getNodeExtension().createExtensionServices();
        return (SeaTunnelServer)extensionServices.get("st:impl:seaTunnelServer");
    }

    private void handleSubmitJob(HttpPostCommand httpPostCommand, String uri) throws IllegalArgumentException {
        JsonNode requestBodyJsonNode;
        HashMap<String, String> requestParams = new HashMap<String, String>();
        RestUtil.buildRequestParams(requestParams, uri);
        byte[] requestBody = httpPostCommand.getData();
        if (requestBody.length == 0) {
            throw new IllegalArgumentException("Request body is empty.");
        }
        try {
            requestBodyJsonNode = RestUtil.convertByteToJsonNode(requestBody);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON format in request body.");
        }
        Config config = RestUtil.buildConfig(requestBodyJsonNode);
        JobConfig jobConfig = new JobConfig();
        jobConfig.setName((String)requestParams.get("jobName"));
        JobImmutableInformationEnv jobImmutableInformationEnv = new JobImmutableInformationEnv(jobConfig, config, this.textCommandService.getNode(), Boolean.parseBoolean((String)requestParams.get("isStartWithSavePoint")), Long.parseLong((String)requestParams.get("jobId")));
        JobImmutableInformation jobImmutableInformation = jobImmutableInformationEnv.build();
        CoordinatorService coordinatorService = this.getSeaTunnelServer().getCoordinatorService();
        Object data = this.textCommandService.getNode().nodeEngine.getSerializationService().toData(jobImmutableInformation);
        PassiveCompletableFuture<Void> voidPassiveCompletableFuture = coordinatorService.submitJob(Long.parseLong(jobConfig.getJobContext().getJobId()), (Data)data);
        voidPassiveCompletableFuture.join();
        Long jobId = jobImmutableInformationEnv.getJobId();
        this.prepareResponse(httpPostCommand, new JsonObject().add("jobId", jobId).add("jobName", (String)requestParams.get("jobName")));
    }

    @Override
    public void handleRejection(HttpPostCommand httpPostCommand) {
        this.handle(httpPostCommand);
    }
}

