/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager.resource;

import java.io.Serializable;
import org.apache.seatunnel.engine.server.resourcemanager.resource.CPU;
import org.apache.seatunnel.engine.server.resourcemanager.resource.Memory;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class ResourceProfile
implements Serializable {
    private final CPU cpu;
    private final Memory heapMemory;

    public ResourceProfile() {
        this.cpu = CPU.of(0);
        this.heapMemory = Memory.of(0L);
    }

    public ResourceProfile(CPU cpu, Memory heapMemory) {
        Preconditions.checkArgument(cpu.getCore() >= 0, "The cpu core cannot be negative");
        Preconditions.checkArgument(heapMemory.getBytes() >= 0L, "The heapMemory bytes cannot be negative");
        this.cpu = cpu;
        this.heapMemory = heapMemory;
    }

    public CPU getCpu() {
        return this.cpu;
    }

    public Memory getHeapMemory() {
        return this.heapMemory;
    }

    public ResourceProfile merge(ResourceProfile other) {
        CPU c = CPU.of(this.cpu.getCore() + other.getCpu().getCore());
        Memory m3 = Memory.of(this.heapMemory.getBytes() + other.heapMemory.getBytes());
        return new ResourceProfile(c, m3);
    }

    public ResourceProfile subtract(ResourceProfile other) {
        CPU c = CPU.of(this.cpu.getCore() - other.getCpu().getCore());
        Memory m3 = Memory.of(this.heapMemory.getBytes() - other.heapMemory.getBytes());
        return new ResourceProfile(c, m3);
    }

    public boolean enoughThan(ResourceProfile other) {
        return this.cpu.getCore() >= other.getCpu().getCore() && this.heapMemory.getBytes() >= other.getHeapMemory().getBytes();
    }

    public String toString() {
        return "ResourceProfile{cpu=" + this.cpu + ", heapMemory=" + this.heapMemory + '}';
    }
}

