/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.dag.logical;

import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.logical.LogicalEdge;
import org.apache.seatunnel.engine.core.dag.logical.LogicalVertex;
import org.apache.seatunnel.engine.core.serializable.JobDataSerializerHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalDag
implements IdentifiedDataSerializable {
    private static final Logger log = LoggerFactory.getLogger(LogicalDag.class);
    private JobConfig jobConfig;
    private final Set<LogicalEdge> edges = new LinkedHashSet<LogicalEdge>();
    private final Map<Long, LogicalVertex> logicalVertexMap = new LinkedHashMap<Long, LogicalVertex>();
    private IdGenerator idGenerator;

    public LogicalDag() {
    }

    public LogicalDag(@NonNull JobConfig jobConfig, @NonNull IdGenerator idGenerator) {
        if (jobConfig == null) {
            throw new NullPointerException("jobConfig is marked non-null but is null");
        }
        if (idGenerator == null) {
            throw new NullPointerException("idGenerator is marked non-null but is null");
        }
        this.jobConfig = jobConfig;
        this.idGenerator = idGenerator;
    }

    public void addLogicalVertex(LogicalVertex logicalVertex) {
        this.logicalVertexMap.put(logicalVertex.getVertexId(), logicalVertex);
    }

    public void addEdge(LogicalEdge logicalEdge) {
        this.edges.add(logicalEdge);
    }

    public Set<LogicalEdge> getEdges() {
        return this.edges;
    }

    public Map<Long, LogicalVertex> getLogicalVertexMap() {
        return this.logicalVertexMap;
    }

    @NonNull
    public JsonObject getLogicalDagAsJson() {
        JsonObject logicalDag = new JsonObject();
        JsonArray vertices = new JsonArray();
        this.logicalVertexMap.values().stream().forEach(v -> {
            JsonObject vertex = new JsonObject();
            vertex.add("id", v.getVertexId());
            vertex.add("name", v.getAction().getName() + "(id=" + v.getVertexId() + ")");
            vertex.add("parallelism", v.getParallelism());
            vertices.add(vertex);
        });
        logicalDag.add("vertices", vertices);
        JsonArray edges = new JsonArray();
        this.edges.stream().forEach(e -> {
            JsonObject edge = new JsonObject();
            edge.add("inputVertex", e.getInputVertex().getAction().getName());
            edge.add("targetVertex", e.getTargetVertex().getAction().getName());
            edges.add(edge);
        });
        logicalDag.add("edges", edges);
        return logicalDag;
    }

    @Override
    public int getFactoryId() {
        return JobDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.logicalVertexMap.size());
        for (Map.Entry<Long, LogicalVertex> entry : this.logicalVertexMap.entrySet()) {
            out.writeLong(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.edges.size());
        for (LogicalEdge edge : this.edges) {
            out.writeObject(edge);
        }
        out.writeObject(this.jobConfig);
        out.writeObject(this.idGenerator);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int vertexCount = in.readInt();
        for (int i = 0; i < vertexCount; ++i) {
            Long key = in.readLong();
            LogicalVertex value = (LogicalVertex)in.readObject();
            this.logicalVertexMap.put(key, value);
        }
        int edgeCount = in.readInt();
        for (int i = 0; i < edgeCount; ++i) {
            LogicalEdge edge = (LogicalEdge)in.readObject();
            edge.recoveryFromVertexMap(this.logicalVertexMap);
            this.edges.add(edge);
        }
        this.jobConfig = (JobConfig)in.readObject();
        this.idGenerator = (IdGenerator)in.readObject();
    }

    public String toString() {
        return this.getLogicalDagAsJson().toString();
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }
}

