/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

public class ConstraintKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ConstraintType constraintType;
    private final String constraintName;
    private final List<ConstraintKeyColumn> columnNames;

    private ConstraintKey(ConstraintType constraintType, String constraintName, List<ConstraintKeyColumn> columnNames) {
        Preconditions.checkNotNull(constraintType, "constraintType must not be null");
        this.constraintType = constraintType;
        this.constraintName = constraintName;
        this.columnNames = columnNames;
    }

    public static ConstraintKey of(ConstraintType constraintType, String constraintName, List<ConstraintKeyColumn> columnNames) {
        return new ConstraintKey(constraintType, constraintName, columnNames);
    }

    public ConstraintKey copy() {
        List<ConstraintKeyColumn> collect2 = this.columnNames.stream().map(ConstraintKeyColumn::copy).collect(Collectors.toList());
        return ConstraintKey.of(this.constraintType, this.constraintName, collect2);
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public List<ConstraintKeyColumn> getColumnNames() {
        return this.columnNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstraintKey)) {
            return false;
        }
        ConstraintKey other = (ConstraintKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConstraintType this$constraintType = this.getConstraintType();
        ConstraintType other$constraintType = other.getConstraintType();
        if (this$constraintType == null ? other$constraintType != null : !((Object)((Object)this$constraintType)).equals((Object)other$constraintType)) {
            return false;
        }
        String this$constraintName = this.getConstraintName();
        String other$constraintName = other.getConstraintName();
        if (this$constraintName == null ? other$constraintName != null : !this$constraintName.equals(other$constraintName)) {
            return false;
        }
        List<ConstraintKeyColumn> this$columnNames = this.getColumnNames();
        List<ConstraintKeyColumn> other$columnNames = other.getColumnNames();
        return !(this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConstraintKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        ConstraintType $constraintType = this.getConstraintType();
        result2 = result2 * 59 + ($constraintType == null ? 43 : ((Object)((Object)$constraintType)).hashCode());
        String $constraintName = this.getConstraintName();
        result2 = result2 * 59 + ($constraintName == null ? 43 : $constraintName.hashCode());
        List<ConstraintKeyColumn> $columnNames = this.getColumnNames();
        result2 = result2 * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        return result2;
    }

    public String toString() {
        return "ConstraintKey(constraintType=" + (Object)((Object)this.getConstraintType()) + ", constraintName=" + this.getConstraintName() + ", columnNames=" + this.getColumnNames() + ")";
    }

    public static enum ColumnSortType {
        ASC,
        DESC;

    }

    public static enum ConstraintType {
        KEY,
        UNIQUE_KEY,
        FOREIGN_KEY;

    }

    public static class ConstraintKeyColumn
    implements Serializable {
        private final String columnName;
        private final ColumnSortType sortType;

        public static ConstraintKeyColumn of(String columnName, ColumnSortType sortType) {
            return new ConstraintKeyColumn(columnName, sortType);
        }

        public ConstraintKeyColumn copy() {
            return ConstraintKeyColumn.of(this.columnName, this.sortType);
        }

        public String getColumnName() {
            return this.columnName;
        }

        public ColumnSortType getSortType() {
            return this.sortType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstraintKeyColumn)) {
                return false;
            }
            ConstraintKeyColumn other = (ConstraintKeyColumn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            ColumnSortType this$sortType = this.getSortType();
            ColumnSortType other$sortType = other.getSortType();
            return !(this$sortType == null ? other$sortType != null : !((Object)((Object)this$sortType)).equals((Object)other$sortType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConstraintKeyColumn;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $columnName = this.getColumnName();
            result2 = result2 * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            ColumnSortType $sortType = this.getSortType();
            result2 = result2 * 59 + ($sortType == null ? 43 : ((Object)((Object)$sortType)).hashCode());
            return result2;
        }

        public String toString() {
            return "ConstraintKey.ConstraintKeyColumn(columnName=" + this.getColumnName() + ", sortType=" + (Object)((Object)this.getSortType()) + ")";
        }

        public ConstraintKeyColumn(String columnName, ColumnSortType sortType) {
            this.columnName = columnName;
            this.sortType = sortType;
        }
    }
}

