/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.JetServiceBackend;
import java.util.function.BiConsumer;

public class JetInfoCollector
implements MetricsCollector {
    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer2) {
        JetConfig jetConfig = node.getNodeEngine().getConfig().getJetConfig();
        boolean isJetEnabled = jetConfig.isEnabled();
        metricsConsumer2.accept(PhoneHomeMetrics.JET_ENABLED, String.valueOf(isJetEnabled));
        metricsConsumer2.accept(PhoneHomeMetrics.JET_RESOURCE_UPLOAD_ENABLED, String.valueOf(jetConfig.isResourceUploadEnabled()));
        if (isJetEnabled) {
            JetServiceBackend jetServiceBackend = (JetServiceBackend)node.getNodeEngine().getService("hz:impl:jetService");
            long jobSubmittedCount = jetServiceBackend.getJobCoordinationService().getJobSubmittedCount();
            metricsConsumer2.accept(PhoneHomeMetrics.JET_JOBS_SUBMITTED, String.valueOf(jobSubmittedCount));
        }
    }
}

