/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.PersistentMemoryDirectoryConfig;
import com.hazelcast.config.PersistentMemoryMode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PersistentMemoryConfig {
    private boolean enabled;
    private List<PersistentMemoryDirectoryConfig> directoryConfigs = new LinkedList<PersistentMemoryDirectoryConfig>();
    private PersistentMemoryMode mode = PersistentMemoryMode.MOUNTED;

    public PersistentMemoryConfig() {
    }

    public PersistentMemoryConfig(@Nonnull PersistentMemoryConfig persistentMemoryConfig) {
        Objects.requireNonNull(persistentMemoryConfig).directoryConfigs.forEach(directoryConfig -> this.addDirectoryConfig(new PersistentMemoryDirectoryConfig((PersistentMemoryDirectoryConfig)directoryConfig)));
        this.enabled = persistentMemoryConfig.enabled;
        this.mode = persistentMemoryConfig.mode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public PersistentMemoryConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    public List<PersistentMemoryDirectoryConfig> getDirectoryConfigs() {
        return this.directoryConfigs;
    }

    public PersistentMemoryConfig setDirectoryConfigs(@Nonnull List<PersistentMemoryDirectoryConfig> directoryConfigs) {
        ArrayList<PersistentMemoryDirectoryConfig> checkedConfigs = new ArrayList<PersistentMemoryDirectoryConfig>(Objects.requireNonNull(directoryConfigs).size());
        for (PersistentMemoryDirectoryConfig configToCheck : directoryConfigs) {
            for (PersistentMemoryDirectoryConfig checkedConfig : checkedConfigs) {
                this.validateDirectoryConfig(configToCheck, checkedConfig);
            }
            checkedConfigs.add(configToCheck);
        }
        this.directoryConfigs = directoryConfigs;
        return this;
    }

    public PersistentMemoryConfig addDirectoryConfig(@Nonnull PersistentMemoryDirectoryConfig directoryConfig) {
        Objects.requireNonNull(directoryConfig);
        for (PersistentMemoryDirectoryConfig existingConfig : this.directoryConfigs) {
            this.validateDirectoryConfig(directoryConfig, existingConfig);
        }
        this.directoryConfigs.add(directoryConfig);
        return this;
    }

    private void validateDirectoryConfig(PersistentMemoryDirectoryConfig directoryConfig, PersistentMemoryDirectoryConfig existingConfig) {
        if (existingConfig.getDirectory().equals(directoryConfig.getDirectory())) {
            throw new InvalidConfigurationException("Persistent directories must be unique. '" + directoryConfig.getDirectory() + "' is already set.");
        }
        if (existingConfig.isNumaNodeSet() != directoryConfig.isNumaNodeSet()) {
            throw new InvalidConfigurationException("NUMA node on all persistent memory directories should either be set or left unset. NUMA node settings for directories '" + directoryConfig.getDirectory() + "' and '" + existingConfig.getDirectory() + "' are not consistent.");
        }
        if (directoryConfig.isNumaNodeSet() && existingConfig.getNumaNode() == directoryConfig.getNumaNode()) {
            throw new InvalidConfigurationException("NUMA node must be set uniquely on the persistent memory directories. " + directoryConfig.getDirectory() + " and " + existingConfig.getDirectory() + " have the same NUMA node set.");
        }
    }

    PersistentMemoryConfig setDirectoryConfig(@Nonnull PersistentMemoryDirectoryConfig directoryConfig) {
        Objects.requireNonNull(directoryConfig);
        this.directoryConfigs.clear();
        this.directoryConfigs.add(directoryConfig);
        return this;
    }

    @Nonnull
    public PersistentMemoryMode getMode() {
        return this.mode;
    }

    public PersistentMemoryConfig setMode(@Nonnull PersistentMemoryMode mode) {
        this.mode = Objects.requireNonNull(mode);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentMemoryConfig that = (PersistentMemoryConfig)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.mode != that.mode) {
            return false;
        }
        return Objects.equals(this.directoryConfigs, that.directoryConfigs);
    }

    public int hashCode() {
        int result2 = this.enabled ? 1 : 0;
        result2 = 31 * result2 + (this.mode != null ? this.mode.hashCode() : 0);
        result2 = 31 * result2 + (this.directoryConfigs != null ? this.directoryConfigs.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "PersistentMemoryConfig{enabled=" + this.enabled + ", mode=" + (Object)((Object)this.mode) + ", directoryConfigs=" + this.directoryConfigs + '}';
    }
}

