/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.fieldmapper;

import com.google.auto.service.AutoService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.ConfigValidator;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportTransform;
import org.apache.seatunnel.transform.exception.FieldMapperTransformErrorCode;
import org.apache.seatunnel.transform.exception.FieldMapperTransformException;
import org.apache.seatunnel.transform.exception.TransformException;
import org.apache.seatunnel.transform.fieldmapper.FieldMapperTransformConfig;
import org.apache.seatunnel.transform.fieldmapper.FieldMapperTransformFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SeaTunnelTransform.class})
public class FieldMapperTransform
extends AbstractCatalogSupportTransform {
    private static final Logger log = LoggerFactory.getLogger(FieldMapperTransform.class);
    public static String PLUGIN_NAME = "FieldMapper";
    private FieldMapperTransformConfig config;
    private List<Integer> needReaderColIndex;

    public FieldMapperTransform(@NonNull FieldMapperTransformConfig config, @NonNull CatalogTable catalogTable) {
        super(catalogTable);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (catalogTable == null) {
            throw new NullPointerException("catalogTable is marked non-null but is null");
        }
        this.config = config;
        Map<String, String> fieldMapper = config.getFieldMapper();
        SeaTunnelRowType seaTunnelRowType = catalogTable.getTableSchema().toPhysicalRowDataType();
        List notFoundField = fieldMapper.keySet().stream().filter(field -> seaTunnelRowType.indexOf(field) == -1).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notFoundField)) {
            throw new TransformException((SeaTunnelErrorCode)FieldMapperTransformErrorCode.INPUT_FIELD_NOT_FOUND, notFoundField.toString());
        }
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        ConfigValidator.of((ReadonlyConfig)ReadonlyConfig.fromConfig((Config)pluginConfig)).validate(new FieldMapperTransformFactory().optionRule());
        this.config = FieldMapperTransformConfig.of(ReadonlyConfig.fromConfig((Config)pluginConfig));
    }

    @Override
    protected SeaTunnelRowType transformRowType(SeaTunnelRowType inputRowType) {
        Map<String, String> fieldMapper = this.config.getFieldMapper();
        this.needReaderColIndex = new ArrayList<Integer>(fieldMapper.size());
        ArrayList outputFiledNameList = new ArrayList(fieldMapper.size());
        ArrayList outputDataTypeList = new ArrayList(fieldMapper.size());
        ArrayList inputFieldNames = Lists.newArrayList((Object[])inputRowType.getFieldNames());
        fieldMapper.forEach((key, value) -> {
            int fieldIndex = inputFieldNames.indexOf(key);
            if (fieldIndex < 0) {
                throw new FieldMapperTransformException((SeaTunnelErrorCode)FieldMapperTransformErrorCode.INPUT_FIELD_NOT_FOUND, "Can not found field " + key + " from inputRowType");
            }
            this.needReaderColIndex.add(fieldIndex);
            outputFiledNameList.add(value);
            outputDataTypeList.add(inputRowType.getFieldTypes()[fieldIndex]);
        });
        return new SeaTunnelRowType(outputFiledNameList.toArray(new String[0]), outputDataTypeList.toArray(new SeaTunnelDataType[0]));
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        Map<String, String> fieldMapper = this.config.getFieldMapper();
        Object[] outputDataArray = new Object[fieldMapper.size()];
        for (int i = 0; i < outputDataArray.length; ++i) {
            outputDataArray[i] = inputRow.getField(this.needReaderColIndex.get(i).intValue());
        }
        SeaTunnelRow outputRow = new SeaTunnelRow(outputDataArray);
        outputRow.setRowKind(inputRow.getRowKind());
        outputRow.setTableId(inputRow.getTableId());
        return outputRow;
    }

    @Override
    protected TableSchema transformTableSchema() {
        Map<String, String> fieldMapper = this.config.getFieldMapper();
        List inputColumns = this.inputCatalogTable.getTableSchema().getColumns();
        SeaTunnelRowType seaTunnelRowType = this.inputCatalogTable.getTableSchema().toPhysicalRowDataType();
        ArrayList outputColumns = new ArrayList(fieldMapper.size());
        this.needReaderColIndex = new ArrayList<Integer>(fieldMapper.size());
        ArrayList inputFieldNames = Lists.newArrayList((Object[])seaTunnelRowType.getFieldNames());
        fieldMapper.forEach((key, value) -> {
            int fieldIndex = inputFieldNames.indexOf(key);
            if (fieldIndex < 0) {
                throw new FieldMapperTransformException((SeaTunnelErrorCode)FieldMapperTransformErrorCode.INPUT_FIELD_NOT_FOUND, "Can not found field " + key + " from inputRowType");
            }
            Column oldColumn = (Column)inputColumns.get(fieldIndex);
            PhysicalColumn outputColumn = PhysicalColumn.of((String)value, (SeaTunnelDataType)oldColumn.getDataType(), (Integer)oldColumn.getColumnLength(), (boolean)oldColumn.isNullable(), (Object)oldColumn.getDefaultValue(), (String)oldColumn.getComment());
            outputColumns.add(outputColumn);
            this.needReaderColIndex.add(fieldIndex);
        });
        List outputConstraintKeys = this.inputCatalogTable.getTableSchema().getConstraintKeys().stream().map(ConstraintKey::copy).collect(Collectors.toList());
        PrimaryKey copiedPrimaryKey = this.inputCatalogTable.getTableSchema().getPrimaryKey() == null ? null : this.inputCatalogTable.getTableSchema().getPrimaryKey().copy();
        return TableSchema.builder().primaryKey(copiedPrimaryKey).columns(outputColumns).constraintKey(outputConstraintKeys).build();
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        return this.inputCatalogTable.getTableId().copy();
    }

    public FieldMapperTransform() {
    }
}

