/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.fake.state.FakeSourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeSourceSplitEnumerator
implements SourceSplitEnumerator<FakeSourceSplit, FakeSourceState> {
    private static final Logger log = LoggerFactory.getLogger(FakeSourceSplitEnumerator.class);
    private final SourceSplitEnumerator.Context<FakeSourceSplit> enumeratorContext;
    private final Map<Integer, Set<FakeSourceSplit>> pendingSplits;
    private final FakeConfig fakeConfig;
    private final Set<FakeSourceSplit> assignedSplits;
    private final Object lock = new Object();

    public FakeSourceSplitEnumerator(SourceSplitEnumerator.Context<FakeSourceSplit> enumeratorContext, FakeConfig config, Set<FakeSourceSplit> assignedSplits) {
        this.enumeratorContext = enumeratorContext;
        this.pendingSplits = new HashMap<Integer, Set<FakeSourceSplit>>();
        this.fakeConfig = config;
        this.assignedSplits = new HashSet<FakeSourceSplit>(assignedSplits);
    }

    public void open() {
    }

    public void run() throws Exception {
        this.discoverySplits();
        this.assignPendingSplits();
    }

    public void close() throws IOException {
    }

    public void addSplitsBack(List<FakeSourceSplit> splits, int subtaskId) {
        log.debug("Fake source add splits back {}, subtaskId:{}", splits, (Object)subtaskId);
        this.addSplitChangeToPendingAssignments(splits);
    }

    public int currentUnassignedSplitSize() {
        return this.pendingSplits.size();
    }

    public void handleSplitRequest(int subtaskId) {
    }

    public void registerReader(int subtaskId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FakeSourceState snapshotState(long checkpointId) throws Exception {
        log.debug("Get lock, begin snapshot fakesource split enumerator...");
        Object object = this.lock;
        synchronized (object) {
            log.debug("Begin snapshot fakesource split enumerator...");
            return new FakeSourceState(this.assignedSplits);
        }
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }

    private void discoverySplits() {
        HashSet<FakeSourceSplit> allSplit = new HashSet<FakeSourceSplit>();
        log.info("Starting to calculate splits.");
        int numReaders = this.enumeratorContext.currentParallelism();
        int readerRowNum = this.fakeConfig.getRowNum();
        int splitNum = this.fakeConfig.getSplitNum();
        int splitRowNum = (int)Math.ceil((double)readerRowNum / (double)splitNum);
        for (int i = 0; i < numReaders; ++i) {
            int index = i;
            for (int num = 0; num < readerRowNum; num += splitRowNum) {
                allSplit.add(new FakeSourceSplit(index, Math.min(splitRowNum, readerRowNum - num)));
                index += numReaders;
            }
        }
        this.assignedSplits.forEach(allSplit::remove);
        this.addSplitChangeToPendingAssignments(allSplit);
        log.info("Assigned {} to {} readers.", allSplit, (Object)numReaders);
        log.info("Calculated splits successfully, the size of splits is {}.", (Object)allSplit.size());
    }

    private void addSplitChangeToPendingAssignments(Collection<FakeSourceSplit> newSplits) {
        for (FakeSourceSplit split : newSplits) {
            int ownerReader = split.getSplitId() % this.enumeratorContext.currentParallelism();
            this.pendingSplits.computeIfAbsent(ownerReader, r -> new HashSet()).add(split);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignPendingSplits() {
        Iterator iterator = this.enumeratorContext.registeredReaders().iterator();
        while (iterator.hasNext()) {
            int pendingReader = (Integer)iterator.next();
            Set<FakeSourceSplit> pendingAssignmentForReader = this.pendingSplits.remove(pendingReader);
            if (pendingAssignmentForReader == null || pendingAssignmentForReader.isEmpty()) continue;
            Object object = this.lock;
            synchronized (object) {
                this.assignedSplits.addAll(pendingAssignmentForReader);
                log.info("Assigning splits to readers {} {}", (Object)pendingReader, pendingAssignmentForReader);
                this.enumeratorContext.assignSplit(pendingReader, new ArrayList<FakeSourceSplit>(pendingAssignmentForReader));
                this.enumeratorContext.signalNoMoreSplits(pendingReader);
            }
        }
    }
}

