/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import java.time.Duration;
import java.time.LocalDateTime;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.StringFormatUtils;
import org.apache.seatunnel.engine.client.SeaTunnelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMetricsRunner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(JobMetricsRunner.class);
    private final SeaTunnelClient seaTunnelClient;
    private final Long jobId;
    private LocalDateTime lastRunTime = LocalDateTime.now();
    private Long lastReadCount = 0L;
    private Long lastWriteCount = 0L;

    public JobMetricsRunner(SeaTunnelClient seaTunnelClient, Long jobId) {
        this.seaTunnelClient = seaTunnelClient;
        this.jobId = jobId;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("job-metrics-runner-" + this.jobId);
        try {
            JobMetricsSummary jobMetricsSummary = this.seaTunnelClient.getJobMetricsSummary(this.jobId);
            LocalDateTime now = LocalDateTime.now();
            long seconds = Duration.between(this.lastRunTime, now).getSeconds();
            long averageRead = (jobMetricsSummary.getSourceReadCount() - this.lastReadCount) / seconds;
            long averageWrite = (jobMetricsSummary.getSinkWriteCount() - this.lastWriteCount) / seconds;
            log.info(StringFormatUtils.formatTable("Job Progress Information", "Job Id", this.jobId, "Read Count So Far", jobMetricsSummary.getSourceReadCount(), "Write Count So Far", jobMetricsSummary.getSinkWriteCount(), "Average Read Count", averageRead + "/s", "Average Write Count", averageWrite + "/s", "Last Statistic Time", DateTimeUtils.toString(this.lastRunTime, DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS), "Current Statistic Time", DateTimeUtils.toString(now, DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS)));
            this.lastRunTime = now;
            this.lastReadCount = jobMetricsSummary.getSourceReadCount();
            this.lastWriteCount = jobMetricsSummary.getSinkWriteCount();
        }
        catch (Exception e) {
            log.warn("Failed to get job metrics summary, it maybe first-run");
        }
    }

    public static class JobMetricsSummary {
        private long sourceReadCount;
        private long sinkWriteCount;

        public long getSourceReadCount() {
            return this.sourceReadCount;
        }

        public long getSinkWriteCount() {
            return this.sinkWriteCount;
        }

        public void setSourceReadCount(long sourceReadCount) {
            this.sourceReadCount = sourceReadCount;
        }

        public void setSinkWriteCount(long sinkWriteCount) {
            this.sinkWriteCount = sinkWriteCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobMetricsSummary)) {
                return false;
            }
            JobMetricsSummary other = (JobMetricsSummary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSourceReadCount() != other.getSourceReadCount()) {
                return false;
            }
            return this.getSinkWriteCount() == other.getSinkWriteCount();
        }

        protected boolean canEqual(Object other) {
            return other instanceof JobMetricsSummary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            long $sourceReadCount = this.getSourceReadCount();
            result2 = result2 * 59 + (int)($sourceReadCount >>> 32 ^ $sourceReadCount);
            long $sinkWriteCount = this.getSinkWriteCount();
            result2 = result2 * 59 + (int)($sinkWriteCount >>> 32 ^ $sinkWriteCount);
            return result2;
        }

        public String toString() {
            return "JobMetricsRunner.JobMetricsSummary(sourceReadCount=" + this.getSourceReadCount() + ", sinkWriteCount=" + this.getSinkWriteCount() + ")";
        }

        public JobMetricsSummary(long sourceReadCount, long sinkWriteCount) {
            this.sourceReadCount = sourceReadCount;
            this.sinkWriteCount = sinkWriteCount;
        }
    }
}

