/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.config;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public final class CheckConfigUtil {
    private CheckConfigUtil() {
    }

    @Deprecated
    public static CheckResult check(Config config, String ... params) {
        return CheckConfigUtil.checkAllExists(config, params);
    }

    public static CheckResult checkAllExists(Config config, String ... params) {
        List missingParams = Arrays.stream(params).filter(param2 -> !CheckConfigUtil.isValidParam(config, param2)).collect(Collectors.toList());
        if (!missingParams.isEmpty()) {
            String errorMsg = String.format("please specify [%s] as non-empty", String.join((CharSequence)",", missingParams));
            return CheckResult.error(errorMsg);
        }
        return CheckResult.success();
    }

    public static CheckResult checkAtLeastOneExists(Config config, String ... params) {
        if (params.length == 0) {
            return CheckResult.success();
        }
        LinkedList<String> missingParams = new LinkedList<String>();
        for (String param2 : params) {
            if (CheckConfigUtil.isValidParam(config, param2)) continue;
            missingParams.add(param2);
        }
        if (missingParams.size() == params.length) {
            String errorMsg = String.format("please specify at least one config of [%s] as non-empty", String.join((CharSequence)",", missingParams));
            return CheckResult.error(errorMsg);
        }
        return CheckResult.success();
    }

    public static boolean isValidParam(Config config, String param2) {
        boolean isValidParam = true;
        if (!config.hasPath(param2)) {
            isValidParam = false;
        } else if (config.getAnyRef(param2) instanceof List) {
            isValidParam = !((List)config.getAnyRef(param2)).isEmpty();
        }
        return isValidParam;
    }

    public static CheckResult mergeCheckResults(CheckResult ... checkResults) {
        List notPassConfig = Arrays.stream(checkResults).filter(item -> !item.isSuccess()).collect(Collectors.toList());
        if (notPassConfig.isEmpty()) {
            return CheckResult.success();
        }
        String errMessage = notPassConfig.stream().map(CheckResult::getMsg).collect(Collectors.joining(","));
        return CheckResult.error(errMessage);
    }
}

