/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.iterator;

import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCursor<T>
implements IdentifiedDataSerializable {
    private List<T> objects;
    private IterationPointer[] pointers;

    public AbstractCursor() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is an internal class")
    public AbstractCursor(List<T> entries, IterationPointer[] pointers) {
        this.objects = entries;
        this.pointers = pointers;
    }

    public List<T> getBatch() {
        return this.objects;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="This is an internal class")
    public IterationPointer[] getIterationPointers() {
        return this.pointers;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    abstract void writeElement(ObjectDataOutput var1, T var2) throws IOException;

    abstract T readElement(ObjectDataInput var1) throws IOException;

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.pointers.length);
        for (IterationPointer pointer : this.pointers) {
            out.writeInt(pointer.getIndex());
            out.writeInt(pointer.getSize());
        }
        out.writeInt(this.objects.size());
        for (Object entry : this.objects) {
            this.writeElement(out, entry);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int pointersCount = in.readInt();
        this.pointers = new IterationPointer[pointersCount];
        for (int i = 0; i < pointersCount; ++i) {
            this.pointers[i] = new IterationPointer(in.readInt(), in.readInt());
        }
        int size2 = in.readInt();
        this.objects = new ArrayList<T>(size2);
        for (int i = 0; i < size2; ++i) {
            this.objects.add(this.readElement(in));
        }
    }
}

