/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.impl.CacheEntriesWithCursor;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.ReadMapOrCacheP;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.query.QueryResultRow;
import com.hazelcast.map.impl.query.ResultSegment;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.PermissionsUtil;
import com.hazelcast.security.impl.function.SecuredFunctions;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.security.Permission;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public final class HazelcastReaders {
    private HazelcastReaders() {
    }

    @Nonnull
    public static ProcessorMetaSupplier readLocalCacheSupplier(final @Nonnull String cacheName) {
        return new ReadMapOrCacheP.LocalProcessorMetaSupplier<InternalCompletableFuture<CacheEntriesWithCursor>, CacheEntriesWithCursor, Map.Entry<Data, Data>>((hzInstance, serializationService) -> new ReadMapOrCacheP.LocalCacheReader((HazelcastInstance)hzInstance, (InternalSerializationService)serializationService, cacheName)){

            @Override
            public Permission getRequiredPermission() {
                return new CachePermission(cacheName, "create", "read");
            }
        };
    }

    @Nonnull
    public static ProcessorSupplier readRemoteCacheSupplier(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return new ReadMapOrCacheP.RemoteProcessorSupplier(clientXml, hzInstance -> new ReadMapOrCacheP.RemoteCacheReader((HazelcastInstance)hzInstance, cacheName));
    }

    @Nonnull
    public static ProcessorMetaSupplier readLocalMapSupplier(final @Nonnull String mapName) {
        return new ReadMapOrCacheP.LocalProcessorMetaSupplier<CompletableFuture<MapEntriesWithCursor>, MapEntriesWithCursor, Map.Entry<Data, Data>>((hzInstance, serializationService) -> new ReadMapOrCacheP.LocalMapReader((HazelcastInstance)hzInstance, (InternalSerializationService)serializationService, mapName)){

            @Override
            public Permission getRequiredPermission() {
                return new MapPermission(mapName, "create", "read");
            }
        };
    }

    @Nonnull
    public static <K, V, T> ProcessorMetaSupplier readLocalMapSupplier(final @Nonnull String mapName, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        Util.checkSerializable(Objects.requireNonNull(predicate), "predicate");
        Util.checkSerializable(Objects.requireNonNull(projection), "projection");
        return new ReadMapOrCacheP.LocalProcessorMetaSupplier<InternalCompletableFuture<ResultSegment>, ResultSegment, QueryResultRow>((hzInstance, serializationService) -> new ReadMapOrCacheP.LocalMapQueryReader((HazelcastInstance)hzInstance, (InternalSerializationService)serializationService, mapName, predicate, projection)){

            @Override
            public Permission getRequiredPermission() {
                return new MapPermission(mapName, "create", "read");
            }
        };
    }

    @Nonnull
    public static ProcessorSupplier readRemoteMapSupplier(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return new ReadMapOrCacheP.RemoteProcessorSupplier(clientXml, hzInstance -> new ReadMapOrCacheP.RemoteMapReader((HazelcastInstance)hzInstance, mapName));
    }

    @Nonnull
    public static <K, V, T> ProcessorSupplier readRemoteMapSupplier(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        Util.checkSerializable(Objects.requireNonNull(predicate), "predicate");
        Util.checkSerializable(Objects.requireNonNull(projection), "projection");
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return new ReadMapOrCacheP.RemoteProcessorSupplier(clientXml, hzInstance -> new ReadMapOrCacheP.RemoteMapQueryReader((HazelcastInstance)hzInstance, mapName, predicate, projection));
    }

    public static ProcessorMetaSupplier localOrRemoteListSupplier(String name, ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        Permission permission = PermissionsUtil.listReadPermission(clientXml, name);
        return ProcessorMetaSupplier.forceTotalParallelismOne(ProcessorSupplier.of(SecuredFunctions.readListProcessorFn(name, clientXml)), name, permission);
    }
}

