/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.nio.ConnectionListenable;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.server.NetworkStats;
import com.hazelcast.internal.server.Server;
import com.hazelcast.internal.server.ServerConnection;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ServerConnectionManager
extends ConnectionListenable<ServerConnection>,
Consumer<Packet> {
    @Nonnull
    public Collection<ServerConnection> getConnections();

    default public int connectionCount(@Nullable Predicate<ServerConnection> predicate) {
        if (predicate == null) {
            return this.getConnections().size();
        }
        return (int)this.getConnections().stream().filter(predicate).count();
    }

    default public boolean register(Address primaryAddress, UUID remoteUuid, ServerConnection connection) {
        return this.register(primaryAddress, primaryAddress, null, remoteUuid, connection, 0);
    }

    public boolean register(Address var1, Address var2, Collection<Address> var3, UUID var4, ServerConnection var5, int var6);

    default public int connectionCount() {
        return this.connectionCount(null);
    }

    @Nullable
    default public ServerConnection get(@Nonnull Address address) {
        return this.get(address, 0);
    }

    @Nullable
    public ServerConnection get(@Nonnull Address var1, int var2);

    @Nonnull
    public List<ServerConnection> getAllConnections(@Nonnull Address var1);

    @Nullable
    default public ServerConnection getOrConnect(@Nonnull Address address) {
        return this.getOrConnect(address, false, 0);
    }

    @Nullable
    public ServerConnection getOrConnect(@Nonnull Address var1, int var2);

    @Nullable
    default public ServerConnection getOrConnect(@Nonnull Address address, boolean silent) {
        return this.getOrConnect(address, silent, 0);
    }

    @Nullable
    public ServerConnection getOrConnect(@Nonnull Address var1, boolean var2, int var3);

    default public boolean transmit(Packet packet, Address targetAddress) {
        return this.transmit(packet, targetAddress, 0);
    }

    public boolean transmit(Packet var1, Address var2, int var3);

    public NetworkStats getNetworkStats();

    public Server getServer();

    default public boolean blockOnConnect(Address address, long timeoutMillis, int streamId) throws InterruptedException {
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(timeoutMillis));
        return false;
    }
}

