/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.gcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.gcp.GcpAddress;
import com.hazelcast.gcp.GcpAuthenticator;
import com.hazelcast.gcp.GcpClient;
import com.hazelcast.gcp.GcpComputeApi;
import com.hazelcast.gcp.GcpConfig;
import com.hazelcast.gcp.GcpMetadataApi;
import com.hazelcast.gcp.GcpProperties;
import com.hazelcast.gcp.Label;
import com.hazelcast.gcp.Utils;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.spi.utils.PortRange;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GcpDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final ILogger LOGGER = Logger.getLogger(GcpDiscoveryStrategy.class);
    private final GcpClient gcpClient;
    private final PortRange portRange;
    private final Map<String, String> memberMetadata = new HashMap<String, String>();

    GcpDiscoveryStrategy(Map<String, Comparable> properties) {
        super(LOGGER, properties);
        try {
            GcpConfig gcpConfig = this.createGcpConfig();
            GcpMetadataApi gcpMetadataApi = new GcpMetadataApi();
            GcpComputeApi gcpComputeApi = new GcpComputeApi();
            GcpAuthenticator gcpAuthenticator = new GcpAuthenticator();
            this.gcpClient = new GcpClient(gcpMetadataApi, gcpComputeApi, gcpAuthenticator, gcpConfig);
            this.portRange = gcpConfig.getHzPort();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("Invalid GCP Discovery Strategy configuration", e);
        }
    }

    GcpDiscoveryStrategy(Map<String, Comparable> properties, GcpClient gcpClient) {
        super(LOGGER, properties);
        this.gcpClient = gcpClient;
        this.portRange = this.createGcpConfig().getHzPort();
    }

    private GcpConfig createGcpConfig() {
        return GcpConfig.builder().setPrivateKeyPath(this.getOrNull(GcpProperties.PRIVATE_KEY_PATH)).setProjects(Utils.splitByComma(this.getOrNull(GcpProperties.PROJECTS))).setZones(Utils.splitByComma(this.getOrNull(GcpProperties.ZONES))).setLabel(this.labelOrNull(GcpProperties.LABEL)).setHzPort(new PortRange((String)((Object)this.getOrDefault(GcpProperties.PORT.getDefinition(), GcpProperties.PORT.getDefaultValue())))).setRegion(this.getOrNull(GcpProperties.REGION)).build();
    }

    private Label labelOrNull(GcpProperties gcpProperties) {
        String labelString = this.getOrNull(gcpProperties);
        if (labelString != null) {
            return new Label(labelString);
        }
        return null;
    }

    private String getOrNull(GcpProperties gcpProperties) {
        return (String)this.getOrNull(gcpProperties.getDefinition());
    }

    @Override
    public Map<String, String> discoverLocalMetadata() {
        if (this.memberMetadata.isEmpty()) {
            this.memberMetadata.put("hazelcast.partition.group.zone", this.gcpClient.getAvailabilityZone());
        }
        return this.memberMetadata;
    }

    @Override
    public Iterable<DiscoveryNode> discoverNodes() {
        try {
            List<GcpAddress> gcpAddresses = this.gcpClient.getAddresses();
            GcpDiscoveryStrategy.logGcpAddresses(gcpAddresses);
            ArrayList<DiscoveryNode> result2 = new ArrayList<DiscoveryNode>();
            for (GcpAddress gcpAddress : gcpAddresses) {
                for (int port = this.portRange.getFromPort(); port <= this.portRange.getToPort(); ++port) {
                    result2.add(GcpDiscoveryStrategy.createDiscoveryNode(gcpAddress, port));
                }
            }
            return result2;
        }
        catch (Exception e) {
            LOGGER.warning("Cannot discover nodes, returning empty list", e);
            return Collections.emptyList();
        }
    }

    private static DiscoveryNode createDiscoveryNode(GcpAddress gcpAddress, int port) throws UnknownHostException {
        Address privateAddress = new Address(gcpAddress.getPrivateAddress(), port);
        Address publicAddress = new Address(gcpAddress.getPublicAddress(), port);
        return new SimpleDiscoveryNode(privateAddress, publicAddress);
    }

    private static void logGcpAddresses(List<GcpAddress> gcpAddresses) {
        if (LOGGER.isFinestEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Found the following GCP instance: ");
            for (GcpAddress gcpAddress : gcpAddresses) {
                stringBuilder.append(String.format("%s, ", gcpAddress));
            }
            LOGGER.finest(stringBuilder.toString());
        }
    }
}

