/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.SimpleEntryView;

public final class SimpleEntryViewCodec {
    private static final int COST_FIELD_OFFSET = 0;
    private static final int CREATION_TIME_FIELD_OFFSET = 8;
    private static final int EXPIRATION_TIME_FIELD_OFFSET = 16;
    private static final int HITS_FIELD_OFFSET = 24;
    private static final int LAST_ACCESS_TIME_FIELD_OFFSET = 32;
    private static final int LAST_STORED_TIME_FIELD_OFFSET = 40;
    private static final int LAST_UPDATE_TIME_FIELD_OFFSET = 48;
    private static final int VERSION_FIELD_OFFSET = 56;
    private static final int TTL_FIELD_OFFSET = 64;
    private static final int MAX_IDLE_FIELD_OFFSET = 72;
    private static final int INITIAL_FRAME_SIZE = 80;

    private SimpleEntryViewCodec() {
    }

    public static void encode(ClientMessage clientMessage, SimpleEntryView<Data, Data> simpleEntryView) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[80]);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 0, simpleEntryView.getCost());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 8, simpleEntryView.getCreationTime());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, simpleEntryView.getExpirationTime());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, simpleEntryView.getHits());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 32, simpleEntryView.getLastAccessTime());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 40, simpleEntryView.getLastStoredTime());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 48, simpleEntryView.getLastUpdateTime());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 56, simpleEntryView.getVersion());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 64, simpleEntryView.getTtl());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 72, simpleEntryView.getMaxIdle());
        clientMessage.add(initialFrame);
        DataCodec.encode(clientMessage, simpleEntryView.getKey());
        DataCodec.encode(clientMessage, simpleEntryView.getValue());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static SimpleEntryView<Data, Data> decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        long cost = FixedSizeTypesCodec.decodeLong(initialFrame.content, 0);
        long creationTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 8);
        long expirationTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        long hits = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        long lastAccessTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 32);
        long lastStoredTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 40);
        long lastUpdateTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 48);
        long version = FixedSizeTypesCodec.decodeLong(initialFrame.content, 56);
        long ttl = FixedSizeTypesCodec.decodeLong(initialFrame.content, 64);
        long maxIdle = FixedSizeTypesCodec.decodeLong(initialFrame.content, 72);
        Data key = DataCodec.decode(iterator2);
        Data value = DataCodec.decode(iterator2);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createSimpleEntryView(key, value, cost, creationTime, expirationTime, hits, lastAccessTime, lastStoredTime, lastUpdateTime, version, ttl, maxIdle);
    }
}

