/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.common.SingleFieldOutputTransform;

@AutoService(value={SeaTunnelTransform.class})
public class ReplaceTransform
extends SingleFieldOutputTransform {
    public static final Option<String> KEY_REPLACE_FIELD = Options.key((String)"replace_field").stringType().noDefaultValue().withDescription("The field you want to replace");
    public static final Option<String> KEY_PATTERN = Options.key((String)"pattern").stringType().noDefaultValue().withDescription("The old string that will be replaced");
    public static final Option<String> KEY_REPLACEMENT = Options.key((String)"replacement").stringType().noDefaultValue().withDescription("The new string for replace");
    public static final Option<Boolean> KEY_IS_REGEX = Options.key((String)"is_regex").booleanType().defaultValue((Object)false).withDescription("Use regex for string match");
    public static final Option<Boolean> KEY_REPLACE_FIRST = Options.key((String)"replace_first").booleanType().noDefaultValue().withDescription("Replace the first match string");
    private int inputFieldIndex;
    private String replaceField;
    private String pattern;
    private String replacement;
    private boolean isRegex;
    private boolean replaceFirst;

    public String getPluginName() {
        return "Replace";
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        CheckResult checkResult = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{KEY_REPLACE_FIELD.key(), KEY_PATTERN.key(), KEY_REPLACEMENT.key()});
        if (!checkResult.isSuccess()) {
            throw new IllegalArgumentException("Failed to check config! " + checkResult.getMsg());
        }
        this.replaceField = pluginConfig.getString(KEY_REPLACE_FIELD.key());
        this.pattern = pluginConfig.getString(KEY_PATTERN.key());
        this.replacement = pluginConfig.getString(KEY_REPLACEMENT.key());
        if (pluginConfig.hasPath(KEY_IS_REGEX.key())) {
            this.isRegex = pluginConfig.getBoolean(KEY_IS_REGEX.key());
        }
        if (pluginConfig.hasPath(KEY_REPLACE_FIRST.key())) {
            this.replaceFirst = pluginConfig.getBoolean(KEY_REPLACE_FIRST.key());
        }
    }

    @Override
    protected void setInputRowType(SeaTunnelRowType rowType) {
        this.inputFieldIndex = rowType.indexOf(this.replaceField);
        if (this.inputFieldIndex == -1) {
            throw new IllegalArgumentException("Cannot find [" + this.replaceField + "] field in input row type");
        }
    }

    @Override
    protected String getOutputFieldName() {
        return this.replaceField;
    }

    @Override
    protected SeaTunnelDataType getOutputFieldDataType() {
        return BasicType.STRING_TYPE;
    }

    @Override
    protected Object getOutputFieldValue(SeaTunnelRowAccessor inputRow) {
        Object inputFieldValue = inputRow.getField(this.inputFieldIndex);
        if (inputFieldValue == null) {
            return null;
        }
        if (this.isRegex) {
            if (this.replaceFirst) {
                return inputFieldValue.toString().replaceFirst(this.pattern, this.replacement);
            }
            return inputFieldValue.toString().replaceAll(this.pattern, this.replacement);
        }
        return inputFieldValue.toString().replace(this.pattern, this.replacement);
    }
}

