/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task;

import java.io.IOException;
import java.util.List;
import org.apache.seatunnel.api.common.metrics.Counter;
import org.apache.seatunnel.api.common.metrics.Meter;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.engine.server.task.flow.OneInputFlowLifeCycle;

public class SeaTunnelSourceCollector<T>
implements Collector<T> {
    private final Object checkpointLock;
    private final List<OneInputFlowLifeCycle<Record<?>>> outputs;
    private final Counter sourceReceivedCount;
    private final Meter sourceReceivedQPS;

    public SeaTunnelSourceCollector(Object checkpointLock, List<OneInputFlowLifeCycle<Record<?>>> outputs, MetricsContext metricsContext) {
        this.checkpointLock = checkpointLock;
        this.outputs = outputs;
        this.sourceReceivedCount = metricsContext.counter("SourceReceivedCount");
        this.sourceReceivedQPS = metricsContext.meter("SourceReceivedQPS");
    }

    @Override
    public void collect(T row) {
        try {
            this.sendRecordToNext(new Record<T>(row));
            this.sourceReceivedCount.inc();
            this.sourceReceivedQPS.markEvent();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getCheckpointLock() {
        return this.checkpointLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRecordToNext(Record<?> record) throws IOException {
        Object object = this.checkpointLock;
        synchronized (object) {
            for (OneInputFlowLifeCycle<Record<?>> output : this.outputs) {
                output.received(record);
            }
        }
    }
}

