/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.execution;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import org.apache.seatunnel.engine.server.execution.Task;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.metrics.SeaTunnelMetricsContext;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;

public class TaskExecutionContext {
    private final Task task;
    private final NodeEngineImpl nodeEngine;

    public TaskExecutionContext(Task task, NodeEngineImpl nodeEngine) {
        this.task = task;
        this.nodeEngine = nodeEngine;
    }

    public <E> InvocationFuture<E> sendToMaster(Operation operation) {
        return NodeEngineUtil.sendOperationToMasterNode(this.nodeEngine, operation);
    }

    public <E> InvocationFuture<E> sendToMember(Operation operation, Address memberID) {
        return NodeEngineUtil.sendOperationToMemberNode(this.nodeEngine, operation, memberID);
    }

    public ILogger getLogger() {
        return this.nodeEngine.getLogger(this.task.getClass());
    }

    public SeaTunnelMetricsContext getOrCreateMetricsContext(TaskLocation taskLocation) {
        IMap<TaskLocation, SeaTunnelMetricsContext> map2 = this.nodeEngine.getHazelcastInstance().getMap("engine_runningJobMetrics");
        return map2.computeIfAbsent(taskLocation, k -> new SeaTunnelMetricsContext());
    }

    public <T> T getTask() {
        return (T)this.task;
    }

    public HazelcastInstance getInstance() {
        return this.nodeEngine.getHazelcastInstance();
    }
}

