/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.execution;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.ShuffleAction;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionEdge;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionPlanGenerator;
import org.apache.seatunnel.engine.server.dag.execution.ExecutionVertex;
import org.apache.seatunnel.engine.server.dag.execution.Pipeline;

public class PipelineGenerator {
    private final IdGenerator idGenerator = new IdGenerator();
    private final Map<Long, List<ExecutionVertex>> inputVerticesMap = new HashMap<Long, List<ExecutionVertex>>();
    private final Map<Long, List<ExecutionVertex>> targetVerticesMap = new HashMap<Long, List<ExecutionVertex>>();
    private final Collection<ExecutionVertex> vertices;
    private final List<ExecutionEdge> edges;

    public PipelineGenerator(Collection<ExecutionVertex> vertices, List<ExecutionEdge> edges) {
        this.vertices = vertices;
        this.edges = edges;
    }

    public List<Pipeline> generatePipelines() {
        List<ExecutionEdge> executionEdges = PipelineGenerator.expandEdgeByParallelism(this.edges);
        List<List<ExecutionEdge>> edgesList = PipelineGenerator.splitUnrelatedEdges(executionEdges);
        edgesList = edgesList.stream().flatMap(e -> this.splitUnionEdge((List<ExecutionEdge>)e).stream()).collect(Collectors.toList());
        IdGenerator idGenerator = new IdGenerator();
        return edgesList.stream().map(e -> {
            HashMap<Long, ExecutionVertex> vertexes = new HashMap<Long, ExecutionVertex>();
            List<ExecutionEdge> pipelineEdges = e.stream().map(edge -> {
                if (!vertexes.containsKey(edge.getLeftVertexId())) {
                    vertexes.put(edge.getLeftVertexId(), edge.getLeftVertex());
                }
                ExecutionVertex source = (ExecutionVertex)vertexes.get(edge.getLeftVertexId());
                if (!vertexes.containsKey(edge.getRightVertexId())) {
                    vertexes.put(edge.getRightVertexId(), edge.getRightVertex());
                }
                ExecutionVertex destination = (ExecutionVertex)vertexes.get(edge.getRightVertexId());
                return new ExecutionEdge(source, destination);
            }).collect(Collectors.toList());
            return new Pipeline((int)idGenerator.getNextId(), pipelineEdges, vertexes);
        }).collect(Collectors.toList());
    }

    private static List<ExecutionEdge> expandEdgeByParallelism(List<ExecutionEdge> edges) {
        return edges;
    }

    private List<List<ExecutionEdge>> splitUnionEdge(List<ExecutionEdge> edges) {
        this.fillVerticesMap(edges);
        if (this.checkCanSplit(edges)) {
            List<ExecutionVertex> sourceVertices = this.getSourceVertices();
            ArrayList<List<ExecutionEdge>> pipelines = new ArrayList<List<ExecutionEdge>>();
            sourceVertices.forEach(sourceVertex -> this.splitUnionVertex((List<List<ExecutionEdge>>)pipelines, (List<ExecutionVertex>)new ArrayList<ExecutionVertex>(), (ExecutionVertex)sourceVertex));
            return pipelines;
        }
        return Collections.singletonList(edges);
    }

    private boolean checkCanSplit(List<ExecutionEdge> edges) {
        return edges.stream().noneMatch(e -> e.getRightVertex().getAction() instanceof ShuffleAction) && edges.stream().anyMatch(e -> this.inputVerticesMap.get(e.getRightVertexId()).size() > 1);
    }

    private void splitUnionVertex(List<List<ExecutionEdge>> pipelines, List<ExecutionVertex> pipeline, ExecutionVertex currentVertex) {
        pipeline.add(this.recreateVertex(currentVertex, pipeline.size() == 0 ? currentVertex.getParallelism() : pipeline.get(pipeline.size() - 1).getParallelism()));
        List<ExecutionVertex> targetVertices = this.targetVerticesMap.get(currentVertex.getVertexId());
        if (targetVertices == null || targetVertices.size() == 0) {
            pipelines.add(this.createExecutionEdges(pipeline));
            return;
        }
        for (int i = 0; i < targetVertices.size(); ++i) {
            if (i > 0) {
                pipeline = this.recreatePipeline(pipeline);
            }
            this.splitUnionVertex(pipelines, pipeline, targetVertices.get(i));
            pipeline.remove(pipeline.size() - 1);
        }
    }

    private List<ExecutionEdge> createExecutionEdges(List<ExecutionVertex> pipeline) {
        Preconditions.checkArgument(pipeline != null && pipeline.size() > 1);
        ArrayList<ExecutionEdge> edges = new ArrayList<ExecutionEdge>(pipeline.size() - 1);
        for (int i = 1; i < pipeline.size(); ++i) {
            edges.add(new ExecutionEdge(pipeline.get(i - 1), pipeline.get(i)));
        }
        return edges;
    }

    private List<ExecutionVertex> recreatePipeline(List<ExecutionVertex> pipeline) {
        return pipeline.stream().map(vertex -> this.recreateVertex((ExecutionVertex)vertex, vertex.getParallelism())).collect(Collectors.toList());
    }

    private ExecutionVertex recreateVertex(ExecutionVertex vertex, int parallelism) {
        long id = this.idGenerator.getNextId();
        Action action = vertex.getAction();
        return new ExecutionVertex(id, ExecutionPlanGenerator.recreateAction(action, id, parallelism), action instanceof ShuffleAction ? vertex.getParallelism() : parallelism);
    }

    private void fillVerticesMap(List<ExecutionEdge> edges) {
        this.inputVerticesMap.clear();
        this.targetVerticesMap.clear();
        edges.forEach(edge -> {
            this.inputVerticesMap.computeIfAbsent(edge.getRightVertexId(), id -> new ArrayList()).add(edge.getLeftVertex());
            this.targetVerticesMap.computeIfAbsent(edge.getLeftVertexId(), id -> new ArrayList()).add(edge.getRightVertex());
        });
    }

    private List<ExecutionVertex> getSourceVertices() {
        ArrayList<ExecutionVertex> sourceVertices = new ArrayList<ExecutionVertex>();
        for (ExecutionVertex vertex : this.vertices) {
            List<ExecutionVertex> inputVertices = this.inputVerticesMap.get(vertex.getVertexId());
            if (inputVertices != null && inputVertices.size() != 0) continue;
            sourceVertices.add(vertex);
        }
        return sourceVertices;
    }

    private static List<List<ExecutionEdge>> splitUnrelatedEdges(List<ExecutionEdge> edges) {
        ArrayList<List<ExecutionEdge>> edgeList = new ArrayList<List<ExecutionEdge>>();
        while (!edges.isEmpty()) {
            edgeList.add(PipelineGenerator.findVertexRelatedEdge(edges, edges.get(0).getLeftVertex()));
        }
        return edgeList;
    }

    private static List<ExecutionEdge> findVertexRelatedEdge(List<ExecutionEdge> edges, ExecutionVertex vertex) {
        List sourceEdges = edges.stream().filter(edge -> edge.getLeftVertex().equals(vertex)).collect(Collectors.toList());
        List destinationEdges = edges.stream().filter(edge -> edge.getRightVertex().equals(vertex)).collect(Collectors.toList());
        ArrayList<ExecutionEdge> relatedEdges = new ArrayList<ExecutionEdge>(sourceEdges);
        relatedEdges.addAll(destinationEdges);
        List relatedActions = sourceEdges.stream().map(ExecutionEdge::getRightVertex).collect(Collectors.toList());
        relatedActions.addAll(destinationEdges.stream().map(ExecutionEdge::getLeftVertex).collect(Collectors.toList()));
        edges.removeAll(relatedEdges);
        relatedEdges.addAll(relatedActions.stream().flatMap(d -> PipelineGenerator.findVertexRelatedEdge(edges, d).stream()).collect(Collectors.toList()));
        return relatedEdges;
    }
}

