/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.engine.checkpoint.storage.PipelineState;
import org.apache.seatunnel.engine.checkpoint.storage.api.CheckpointStorage;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.checkpoint.CheckpointIDCounter;
import org.apache.seatunnel.engine.core.checkpoint.CheckpointType;
import org.apache.seatunnel.engine.serializer.api.Serializer;
import org.apache.seatunnel.engine.serializer.protobuf.ProtoStuffSerializer;
import org.apache.seatunnel.engine.server.checkpoint.ActionState;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointBarrier;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCloseReason;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCoordinatorState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCoordinatorStatus;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointException;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointManager;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointPlan;
import org.apache.seatunnel.engine.server.checkpoint.CompletedCheckpoint;
import org.apache.seatunnel.engine.server.checkpoint.PendingCheckpoint;
import org.apache.seatunnel.engine.server.checkpoint.SubtaskStatus;
import org.apache.seatunnel.engine.server.checkpoint.TaskStatistics;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointBarrierTriggerOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointFinishedOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.NotifyTaskRestoreOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.NotifyTaskStartOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskAcknowledgeOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskReportStatusOperation;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.task.record.Barrier;
import org.apache.seatunnel.engine.server.task.statemachine.SeaTunnelTaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointCoordinator.class);
    private final long jobId;
    private final int pipelineId;
    private final CheckpointManager checkpointManager;
    private final CheckpointStorage checkpointStorage;
    private final CheckpointIDCounter checkpointIdCounter;
    private final transient Serializer serializer;
    private final Map<Long, Integer> pipelineTasks;
    private final Map<Long, SeaTunnelTaskState> pipelineTaskStatus;
    private final CheckpointPlan plan;
    private final Set<TaskLocation> readyToCloseStartingTask;
    private final ConcurrentHashMap<Long, PendingCheckpoint> pendingCheckpoints;
    private final ArrayDeque<CompletedCheckpoint> completedCheckpoints;
    private volatile CompletedCheckpoint latestCompletedCheckpoint = null;
    private final CheckpointConfig coordinatorConfig;
    private int tolerableFailureCheckpoints;
    private transient ScheduledExecutorService scheduler;
    private final AtomicLong latestTriggerTimestamp = new AtomicLong(0L);
    private final AtomicInteger pendingCounter = new AtomicInteger(0);
    private final Object lock = new Object();
    private volatile boolean shutdown;
    private volatile boolean isAllTaskReady = false;
    private final ExecutorService executorService;
    private CompletableFuture<CheckpointCoordinatorState> checkpointCoordinatorFuture;

    public CheckpointCoordinator(CheckpointManager manager, CheckpointStorage checkpointStorage, CheckpointConfig checkpointConfig, long jobId, CheckpointPlan plan, CheckpointIDCounter checkpointIdCounter, PipelineState pipelineState, ExecutorService executorService) {
        this.executorService = executorService;
        this.checkpointManager = manager;
        this.checkpointStorage = checkpointStorage;
        this.jobId = jobId;
        this.pipelineId = plan.getPipelineId();
        this.plan = plan;
        this.coordinatorConfig = checkpointConfig;
        this.tolerableFailureCheckpoints = this.coordinatorConfig.getTolerableFailureCheckpoints();
        this.pendingCheckpoints = new ConcurrentHashMap();
        this.completedCheckpoints = new ArrayDeque(this.coordinatorConfig.getStorage().getMaxRetainedCheckpoints() + 1);
        this.scheduler = Executors.newScheduledThreadPool(2, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName(String.format("checkpoint-coordinator-%s/%s", this.pipelineId, jobId));
            return thread;
        });
        this.serializer = new ProtoStuffSerializer();
        this.pipelineTasks = CheckpointCoordinator.getPipelineTasks(plan.getPipelineSubtasks());
        this.pipelineTaskStatus = new ConcurrentHashMap<Long, SeaTunnelTaskState>();
        this.checkpointIdCounter = checkpointIdCounter;
        this.readyToCloseStartingTask = new CopyOnWriteArraySet<TaskLocation>();
        if (pipelineState != null) {
            this.latestCompletedCheckpoint = this.serializer.deserialize(pipelineState.getStates(), CompletedCheckpoint.class);
        }
        this.checkpointCoordinatorFuture = new CompletableFuture();
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    protected void reportedTask(TaskReportStatusOperation operation) {
        this.pipelineTaskStatus.put(operation.getLocation().getTaskID(), operation.getStatus());
        CompletableFuture.runAsync(() -> {
            switch (operation.getStatus()) {
                case WAITING_RESTORE: {
                    this.restoreTaskState(operation.getLocation());
                    break;
                }
                case READY_START: {
                    this.allTaskReady();
                    break;
                }
            }
        }, this.executorService).exceptionally(error -> {
            this.handleCoordinatorError("task running failed", (Throwable)error, CheckpointCloseReason.CHECKPOINT_INSIDE_ERROR);
            return null;
        });
    }

    private void handleCoordinatorError(String message, Throwable e, CheckpointCloseReason reason) {
        LOG.error(message, e);
        this.handleCoordinatorError(reason, e);
    }

    private void handleCoordinatorError(CheckpointCloseReason reason, Throwable e) {
        CheckpointException checkpointException = new CheckpointException(reason, e);
        this.cleanPendingCheckpoint(reason);
        this.checkpointCoordinatorFuture.complete(new CheckpointCoordinatorState(CheckpointCoordinatorStatus.FAILED, ExceptionUtils.getMessage(checkpointException)));
        this.checkpointManager.handleCheckpointError(this.pipelineId);
    }

    private void restoreTaskState(TaskLocation taskLocation) {
        ArrayList<ActionSubtaskState> states = new ArrayList<ActionSubtaskState>();
        if (this.latestCompletedCheckpoint != null) {
            Integer currentParallelism = this.pipelineTasks.get(taskLocation.getTaskVertexId());
            this.plan.getSubtaskActions().get(taskLocation).forEach(tuple -> {
                ActionState actionState = this.latestCompletedCheckpoint.getTaskStates().get(tuple.f0());
                if (actionState == null) {
                    return;
                }
                if (CheckpointPlan.COORDINATOR_INDEX.equals(tuple.f1())) {
                    states.add(actionState.getCoordinatorState());
                    return;
                }
                for (int i = ((Integer)tuple.f1()).intValue(); i < actionState.getParallelism(); i += currentParallelism.intValue()) {
                    states.add(actionState.getSubtaskStates().get(i));
                }
            });
        }
        this.checkpointManager.sendOperationToMemberNode(new NotifyTaskRestoreOperation(taskLocation, states)).join();
    }

    private void allTaskReady() {
        if (this.pipelineTaskStatus.size() != this.plan.getPipelineSubtasks().size()) {
            return;
        }
        for (SeaTunnelTaskState status : this.pipelineTaskStatus.values()) {
            if (SeaTunnelTaskState.READY_START == status) continue;
            return;
        }
        this.isAllTaskReady = true;
        InvocationFuture<?>[] futures = this.notifyTaskStart();
        CompletableFuture.allOf(futures).join();
        this.scheduleTriggerPendingCheckpoint(this.coordinatorConfig.getCheckpointInterval());
    }

    public InvocationFuture<?>[] notifyTaskStart() {
        return (InvocationFuture[])this.plan.getPipelineSubtasks().stream().map(NotifyTaskStartOperation::new).map(this.checkpointManager::sendOperationToMemberNode).toArray(InvocationFuture[]::new);
    }

    private void scheduleTriggerPendingCheckpoint(long delayMills) {
        this.scheduleTriggerPendingCheckpoint(CheckpointType.CHECKPOINT_TYPE, delayMills);
    }

    private void scheduleTriggerPendingCheckpoint(CheckpointType checkpointType, long delayMills) {
        this.scheduler.schedule(() -> this.tryTriggerPendingCheckpoint(checkpointType), delayMills, TimeUnit.MILLISECONDS);
    }

    protected void readyToClose(TaskLocation taskLocation) {
        this.readyToCloseStartingTask.add(taskLocation);
        if (this.readyToCloseStartingTask.size() == this.plan.getStartingSubtasks().size()) {
            this.tryTriggerPendingCheckpoint(CheckpointType.COMPLETED_POINT_TYPE);
        }
    }

    protected void restoreCoordinator(boolean alreadyStarted) {
        LOG.info("received restore CheckpointCoordinator with alreadyStarted= " + alreadyStarted);
        this.checkpointCoordinatorFuture = new CompletableFuture();
        this.cleanPendingCheckpoint(CheckpointCloseReason.CHECKPOINT_COORDINATOR_RESET);
        this.shutdown = false;
        if (alreadyStarted) {
            this.isAllTaskReady = true;
            this.tryTriggerPendingCheckpoint(CheckpointType.CHECKPOINT_TYPE);
        } else {
            this.isAllTaskReady = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryTriggerPendingCheckpoint(CheckpointType checkpointType) {
        if (Thread.currentThread().isInterrupted()) {
            LOG.warn("currentThread already be interrupted, skip trigger checkpoint");
            return;
        }
        long currentTimestamp = Instant.now().toEpochMilli();
        if (this.notFinalCheckpoint(checkpointType) && (currentTimestamp - this.latestTriggerTimestamp.get() < this.coordinatorConfig.getCheckpointInterval() || this.pendingCounter.get() >= this.coordinatorConfig.getMaxConcurrentCheckpoints() || !this.isAllTaskReady)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isCompleted() || this.isShutdown()) {
                LOG.warn(String.format("can't trigger checkpoint with type: %s, because checkpoint coordinator already have last completed checkpoint: (%s) or shutdown (%b).", new Object[]{checkpointType, this.latestCompletedCheckpoint != null ? this.latestCompletedCheckpoint.getCheckpointType() : "null", this.shutdown}));
                return;
            }
            if (!this.notFinalCheckpoint(checkpointType) && this.pendingCounter.get() > 0) {
                this.scheduleTriggerPendingCheckpoint(checkpointType, 500L);
                return;
            }
            CompletableFuture<PendingCheckpoint> pendingCheckpoint = this.createPendingCheckpoint(currentTimestamp, checkpointType);
            this.startTriggerPendingCheckpoint(pendingCheckpoint);
            this.pendingCounter.incrementAndGet();
            if (this.notFinalCheckpoint(checkpointType)) {
                this.scheduleTriggerPendingCheckpoint(this.coordinatorConfig.getCheckpointInterval());
            }
        }
    }

    private boolean notFinalCheckpoint(CheckpointType checkpointType) {
        return checkpointType.equals((Object)CheckpointType.CHECKPOINT_TYPE);
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public static Map<Long, Integer> getPipelineTasks(Set<TaskLocation> pipelineSubtasks) {
        return pipelineSubtasks.stream().collect(Collectors.groupingBy(TaskLocation::getTaskVertexId, Collectors.toList())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).size()));
    }

    public PassiveCompletableFuture<CompletedCheckpoint> startSavepoint() {
        CompletableFuture<PendingCheckpoint> savepoint = this.createPendingCheckpoint(Instant.now().toEpochMilli(), CheckpointType.SAVEPOINT_TYPE);
        this.startTriggerPendingCheckpoint(savepoint);
        return savepoint.join().getCompletableFuture();
    }

    private void startTriggerPendingCheckpoint(CompletableFuture<PendingCheckpoint> pendingCompletableFuture) {
        pendingCompletableFuture.thenAccept(pendingCheckpoint -> {
            LOG.info("wait checkpoint completed: " + pendingCheckpoint.getCheckpointId());
            PassiveCompletableFuture<CompletedCheckpoint> completableFuture = pendingCheckpoint.getCompletableFuture();
            completableFuture.whenComplete((completedCheckpoint, error) -> {
                if (error != null) {
                    this.handleCoordinatorError("trigger checkpoint failed", (Throwable)error, CheckpointCloseReason.CHECKPOINT_INSIDE_ERROR);
                } else if (completedCheckpoint != null) {
                    try {
                        this.completePendingCheckpoint((CompletedCheckpoint)completedCheckpoint);
                    }
                    catch (Throwable e) {
                        this.handleCoordinatorError("complete checkpoint failed", e, CheckpointCloseReason.CHECKPOINT_INSIDE_ERROR);
                    }
                } else {
                    LOG.info("skip this checkpoint cause by completedCheckpoint is null");
                }
            });
            LOG.debug("trigger checkpoint barrier {}", (Object)pendingCheckpoint.getInfo());
            CompletionStage completableFutureArray = CompletableFuture.supplyAsync(() -> new CheckpointBarrier(pendingCheckpoint.getCheckpointId(), pendingCheckpoint.getCheckpointTimestamp(), pendingCheckpoint.getCheckpointType()), this.executorService).thenApplyAsync(this::triggerCheckpoint, (Executor)this.executorService);
            try {
                CompletableFuture.allOf(new CompletableFuture[]{completableFutureArray}).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                LOG.error(ExceptionUtils.getMessage(e));
                return;
            }
            LOG.debug("Start a scheduled task to prevent checkpoint timeouts for barrier " + pendingCheckpoint.getInfo());
            this.scheduler.schedule(() -> {
                if (this.pendingCheckpoints.get(pendingCheckpoint.getCheckpointId()) != null && !pendingCheckpoint.isFullyAcknowledged() && this.tolerableFailureCheckpoints-- <= 0) {
                    LOG.debug("timeout checkpoint: " + pendingCheckpoint.getInfo());
                    this.handleCoordinatorError(CheckpointCloseReason.CHECKPOINT_EXPIRED, null);
                }
            }, this.coordinatorConfig.getCheckpointTimeout(), TimeUnit.MILLISECONDS);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<PendingCheckpoint> createPendingCheckpoint(long triggerTimestamp, CheckpointType checkpointType) {
        Object object = this.lock;
        synchronized (object) {
            CompletableFuture<Long> idFuture = !checkpointType.equals((Object)CheckpointType.COMPLETED_POINT_TYPE) ? CompletableFuture.supplyAsync(() -> {
                try {
                    return this.checkpointIdCounter.getAndIncrement();
                }
                catch (Throwable e) {
                    this.handleCoordinatorError("get checkpoint id failed", e, CheckpointCloseReason.CHECKPOINT_INSIDE_ERROR);
                    throw new CompletionException(e);
                }
            }, this.executorService) : CompletableFuture.supplyAsync(() -> Barrier.PREPARE_CLOSE_BARRIER_ID, this.executorService);
            return this.triggerPendingCheckpoint(triggerTimestamp, idFuture, checkpointType);
        }
    }

    CompletableFuture<PendingCheckpoint> triggerPendingCheckpoint(long triggerTimestamp, CompletableFuture<Long> idFuture, CheckpointType checkpointType) {
        assert (Thread.holdsLock(this.lock));
        this.latestTriggerTimestamp.set(triggerTimestamp);
        return ((CompletableFuture)idFuture.thenApplyAsync(checkpointId -> new PendingCheckpoint(this.jobId, this.plan.getPipelineId(), (long)checkpointId, triggerTimestamp, checkpointType, this.getNotYetAcknowledgedTasks(), this.getTaskStatistics(), this.getActionStates()), (Executor)this.executorService)).thenApplyAsync(pendingCheckpoint -> {
            this.pendingCheckpoints.put(pendingCheckpoint.getCheckpointId(), (PendingCheckpoint)pendingCheckpoint);
            return pendingCheckpoint;
        }, (Executor)this.executorService);
    }

    private Set<Long> getNotYetAcknowledgedTasks() {
        return this.plan.getPipelineSubtasks().stream().map(TaskLocation::getTaskID).collect(Collectors.toCollection(CopyOnWriteArraySet::new));
    }

    private Map<ActionStateKey, ActionState> getActionStates() {
        return this.plan.getPipelineActions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ActionState((ActionStateKey)entry.getKey(), (Integer)entry.getValue())));
    }

    private Map<Long, TaskStatistics> getTaskStatistics() {
        return this.pipelineTasks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new TaskStatistics((Long)entry.getKey(), (Integer)entry.getValue())));
    }

    public InvocationFuture<?>[] triggerCheckpoint(CheckpointBarrier checkpointBarrier) {
        return (InvocationFuture[])this.plan.getStartingSubtasks().stream().map(taskLocation -> new CheckpointBarrierTriggerOperation(checkpointBarrier, (TaskLocation)taskLocation)).map(this.checkpointManager::sendOperationToMemberNode).toArray(InvocationFuture[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanPendingCheckpoint(CheckpointCloseReason closedReason) {
        this.shutdown = true;
        this.isAllTaskReady = false;
        Object object = this.lock;
        synchronized (object) {
            LOG.info("start clean pending checkpoint cause {}", (Object)closedReason.message());
            if (!this.pendingCheckpoints.isEmpty()) {
                this.pendingCheckpoints.values().forEach(pendingCheckpoint -> pendingCheckpoint.abortCheckpoint(closedReason, null));
                this.pendingCheckpoints.clear();
            }
            this.pendingCounter.set(0);
            this.scheduler.shutdownNow();
            this.scheduler = Executors.newScheduledThreadPool(1, runnable -> {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName(String.format("checkpoint-coordinator-%s/%s", this.pipelineId, this.jobId));
                return thread;
            });
        }
    }

    protected void acknowledgeTask(TaskAcknowledgeOperation ackOperation) {
        long checkpointId = ackOperation.getBarrier().getId();
        PendingCheckpoint pendingCheckpoint = this.pendingCheckpoints.get(checkpointId);
        TaskLocation location = ackOperation.getTaskLocation();
        LOG.debug("task[{}]({}/{}) ack. {}", location.getTaskID(), location.getPipelineId(), location.getJobId(), ackOperation.getBarrier().toString());
        pendingCheckpoint.acknowledgeTask(location, ackOperation.getStates(), CheckpointType.SAVEPOINT_TYPE == pendingCheckpoint.getCheckpointType() ? SubtaskStatus.SAVEPOINT_PREPARE_CLOSE : SubtaskStatus.RUNNING);
    }

    public void completePendingCheckpoint(CompletedCheckpoint completedCheckpoint) {
        LOG.debug("pending checkpoint({}/{}@{}) completed! cost: {}, trigger: {}, completed: {}", completedCheckpoint.getCheckpointId(), completedCheckpoint.getPipelineId(), completedCheckpoint.getJobId(), completedCheckpoint.getCompletedTimestamp() - completedCheckpoint.getCheckpointTimestamp(), completedCheckpoint.getCheckpointTimestamp(), completedCheckpoint.getCompletedTimestamp());
        long checkpointId = completedCheckpoint.getCheckpointId();
        this.pendingCheckpoints.remove(checkpointId);
        this.pendingCounter.decrementAndGet();
        if (this.pendingCheckpoints.size() + 1 == this.coordinatorConfig.getMaxConcurrentCheckpoints() && this.notFinalCheckpoint(completedCheckpoint.getCheckpointType())) {
            this.scheduleTriggerPendingCheckpoint(0L);
        }
        this.completedCheckpoints.addLast(completedCheckpoint);
        try {
            byte[] states = this.serializer.serialize(completedCheckpoint);
            this.checkpointStorage.storeCheckPoint(PipelineState.builder().checkpointId(checkpointId).jobId(String.valueOf(this.jobId)).pipelineId(this.pipelineId).states(states).build());
            if (this.completedCheckpoints.size() % this.coordinatorConfig.getStorage().getMaxRetainedCheckpoints() == 0 && this.completedCheckpoints.size() / this.coordinatorConfig.getStorage().getMaxRetainedCheckpoints() > 1) {
                ArrayList<String> needDeleteCheckpointId = new ArrayList<String>();
                for (int i = 0; i < this.coordinatorConfig.getStorage().getMaxRetainedCheckpoints(); ++i) {
                    needDeleteCheckpointId.add(this.completedCheckpoints.removeFirst().getCheckpointId() + "");
                }
                this.checkpointStorage.deleteCheckpoint(String.valueOf(completedCheckpoint.getJobId()), String.valueOf(completedCheckpoint.getPipelineId()), needDeleteCheckpointId);
            }
        }
        catch (Throwable e) {
            LOG.error("store checkpoint states failed.", e);
            ExceptionUtil.sneakyThrow(e);
        }
        LOG.info("pending checkpoint({}/{}@{}) notify finished!", completedCheckpoint.getCheckpointId(), completedCheckpoint.getPipelineId(), completedCheckpoint.getJobId());
        InvocationFuture<?>[] invocationFutures = this.notifyCheckpointCompleted(checkpointId);
        CompletableFuture.allOf(invocationFutures).join();
        this.latestCompletedCheckpoint = completedCheckpoint;
        if (this.isCompleted()) {
            this.cleanPendingCheckpoint(CheckpointCloseReason.CHECKPOINT_COORDINATOR_COMPLETED);
            this.checkpointCoordinatorFuture.complete(new CheckpointCoordinatorState(CheckpointCoordinatorStatus.FINISHED, null));
        }
    }

    public InvocationFuture<?>[] notifyCheckpointCompleted(long checkpointId) {
        return (InvocationFuture[])this.plan.getPipelineSubtasks().stream().map(taskLocation -> new CheckpointFinishedOperation((TaskLocation)taskLocation, checkpointId, true)).map(this.checkpointManager::sendOperationToMemberNode).toArray(InvocationFuture[]::new);
    }

    public boolean isCompleted() {
        if (this.latestCompletedCheckpoint == null) {
            return false;
        }
        return this.latestCompletedCheckpoint.getCheckpointType() == CheckpointType.COMPLETED_POINT_TYPE || this.latestCompletedCheckpoint.getCheckpointType() == CheckpointType.SAVEPOINT_TYPE;
    }

    public boolean isEndOfSavePoint() {
        if (this.latestCompletedCheckpoint == null) {
            return false;
        }
        return this.latestCompletedCheckpoint.getCheckpointType() == CheckpointType.SAVEPOINT_TYPE;
    }

    public PassiveCompletableFuture<CheckpointCoordinatorState> waitCheckpointCoordinatorComplete() {
        return new PassiveCompletableFuture<CheckpointCoordinatorState>(this.checkpointCoordinatorFuture);
    }

    public PassiveCompletableFuture<CheckpointCoordinatorState> cancelCheckpoint() {
        if (this.checkpointCoordinatorFuture.isDone()) {
            return new PassiveCompletableFuture<CheckpointCoordinatorState>(this.checkpointCoordinatorFuture);
        }
        this.cleanPendingCheckpoint(CheckpointCloseReason.PIPELINE_END);
        CheckpointCoordinatorState checkpointCoordinatorState = new CheckpointCoordinatorState(CheckpointCoordinatorStatus.CANCELED, null);
        this.checkpointCoordinatorFuture.complete(checkpointCoordinatorState);
        return new PassiveCompletableFuture<CheckpointCoordinatorState>(this.checkpointCoordinatorFuture);
    }

    public CheckpointIDCounter getCheckpointIdCounter() {
        return this.checkpointIdCounter;
    }
}

