/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.parse;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.api.env.ParsingMode;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SupportDataSaveMode;
import org.apache.seatunnel.api.table.catalog.CatalogOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.core.starter.utils.ConfigBuilder;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.exception.JobDefineCheckException;
import org.apache.seatunnel.engine.common.loader.SeaTunnelChildFirstClassLoader;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.dag.actions.SinkConfig;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.core.parse.JobConfigParser;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import scala.Tuple2;

public class MultipleTableJobConfigParser {
    private static final ILogger LOGGER = Logger.getLogger(JobConfigParser.class);
    private final IdGenerator idGenerator;
    private final JobConfig jobConfig;
    private final List<URL> commonPluginJars;
    private final Config seaTunnelJobConfig;
    private final ReadonlyConfig envOptions;
    private final JobConfigParser fallbackParser;
    private final ParsingMode parsingMode;

    public MultipleTableJobConfigParser(String jobDefineFilePath, IdGenerator idGenerator, JobConfig jobConfig) {
        this(jobDefineFilePath, idGenerator, jobConfig, Collections.emptyList());
    }

    public MultipleTableJobConfigParser(String jobDefineFilePath, IdGenerator idGenerator, JobConfig jobConfig, List<URL> commonPluginJars) {
        this.idGenerator = idGenerator;
        this.jobConfig = jobConfig;
        this.commonPluginJars = commonPluginJars;
        this.seaTunnelJobConfig = ConfigBuilder.of(Paths.get(jobDefineFilePath, new String[0]));
        this.envOptions = ReadonlyConfig.fromConfig(this.seaTunnelJobConfig.getConfig("env"));
        this.fallbackParser = new JobConfigParser(jobDefineFilePath, idGenerator, jobConfig, commonPluginJars);
        this.parsingMode = this.envOptions.get(EnvCommonOptions.DAG_PARSING_MODE);
    }

    /*
     * WARNING - void declaration
     */
    public ImmutablePair<List<Action>, Set<URL>> parse() {
        void var7_10;
        if (this.parsingMode == ParsingMode.SINGLENESS) {
            return this.fallbackParser.parse();
        }
        ArrayList<URL> connectorJars = new ArrayList();
        try {
            connectorJars = FileUtils.searchJarFiles(Common.connectorJarDir("seatunnel"));
        }
        catch (IOException e) {
            LOGGER.info(e);
        }
        SeaTunnelChildFirstClassLoader classLoader = new SeaTunnelChildFirstClassLoader(connectorJars);
        Thread.currentThread().setContextClassLoader(classLoader);
        List<? extends Config> sourceConfigs = this.seaTunnelJobConfig.getConfigList("source");
        List<? extends Config> sinkConfigs = this.seaTunnelJobConfig.getConfigList("sink");
        if (CollectionUtils.isEmpty(sourceConfigs) || CollectionUtils.isEmpty(sinkConfigs)) {
            throw new JobDefineCheckException("Source And Sink can not be null");
        }
        this.fillJobConfig();
        HashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap = new HashMap<String, List<Tuple2<CatalogTable, Action>>>();
        for (Config config : sourceConfigs) {
            Tuple2<String, List<Tuple2<CatalogTable, Action>>> tuple2 = this.parserSource(config, classLoader);
            tableWithActionMap.put(tuple2._1(), tuple2._2());
        }
        ArrayList<Action> sinkActions = new ArrayList<Action>();
        boolean bl = false;
        while (var7_10 < sinkConfigs.size()) {
            Config sinkConfig = sinkConfigs.get((int)var7_10);
            sinkActions.addAll(this.parserSink((int)var7_10, sinkConfig, classLoader, tableWithActionMap));
            ++var7_10;
        }
        Set<URL> set = this.getUsedFactoryUrls(sinkActions);
        set.addAll(this.commonPluginJars);
        sinkActions.forEach(this::addCommonPluginJarsToAction);
        return new ImmutablePair<List<Action>, Set<URL>>(sinkActions, set);
    }

    public Set<URL> getUsedFactoryUrls(List<Action> sinkActions) {
        HashSet<URL> urls = new HashSet<URL>();
        this.fillUsedFactoryUrls(sinkActions, urls);
        return urls;
    }

    private void fillUsedFactoryUrls(List<Action> actions, Set<URL> result2) {
        actions.forEach(action -> {
            result2.addAll(action.getJarUrls());
            if (!action.getUpstream().isEmpty()) {
                this.fillUsedFactoryUrls(action.getUpstream(), result2);
            }
        });
    }

    void addCommonPluginJarsToAction(Action action) {
        action.getJarUrls().addAll(this.commonPluginJars);
        if (!action.getUpstream().isEmpty()) {
            action.getUpstream().forEach(this::addCommonPluginJarsToAction);
        }
    }

    private void fillJobConfig() {
        this.jobConfig.getJobContext().setJobMode(this.envOptions.get(EnvCommonOptions.JOB_MODE));
        if (StringUtils.isEmpty(this.jobConfig.getName()) || this.jobConfig.getName().equals("SeaTunnel")) {
            this.jobConfig.setName(this.envOptions.get(EnvCommonOptions.JOB_NAME));
        }
        this.envOptions.getOptional(EnvCommonOptions.CHECKPOINT_INTERVAL).ifPresent(interval -> this.jobConfig.getEnvOptions().put(EnvCommonOptions.CHECKPOINT_INTERVAL.key(), interval));
    }

    public Tuple2<String, List<Tuple2<CatalogTable, Action>>> parserSource(Config sourceConfig, ClassLoader classLoader) {
        List<CatalogTable> catalogTables = CatalogTableUtil.getCatalogTables(sourceConfig, classLoader);
        if (catalogTables.isEmpty()) {
            throw new JobDefineCheckException("The source needs catalog table, please configure `catalog` or `schema` options.");
        }
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig(sourceConfig);
        String factoryId = MultipleTableJobConfigParser.getFactoryId(readonlyConfig);
        String tableId = readonlyConfig.getOptional(CommonOptions.RESULT_TABLE_NAME).orElse("default");
        if (this.parsingMode == ParsingMode.SHARDING) {
            catalogTables = Collections.singletonList(catalogTables.get(0));
        }
        List sources = FactoryUtil.createAndPrepareSource(catalogTables, readonlyConfig, classLoader, factoryId);
        HashSet<URL> factoryUrls = new HashSet<URL>();
        URL factoryUrl = FactoryUtil.getFactoryUrl(FactoryUtil.discoverFactory(classLoader, TableSourceFactory.class, factoryId));
        factoryUrls.add(factoryUrl);
        MultipleTableJobConfigParser.getCatalogFactoryUrl(sourceConfig, classLoader).ifPresent(factoryUrls::add);
        ArrayList actions = new ArrayList();
        int parallelism = this.getParallelism(readonlyConfig);
        for (int configIndex = 0; configIndex < sources.size(); ++configIndex) {
            Tuple2 tuple2 = sources.get(configIndex);
            long id = this.idGenerator.getNextId();
            String actionName = JobConfigParser.createSourceActionName(configIndex, factoryId, tableId);
            SourceAction action = new SourceAction(id, actionName, tuple2._1(), factoryUrls);
            action.setParallelism(parallelism);
            for (CatalogTable catalogTable : tuple2._2()) {
                actions.add(new Tuple2(catalogTable, action));
            }
        }
        return new Tuple2<String, List<Tuple2<CatalogTable, Action>>>(tableId, actions);
    }

    public static Optional<URL> getCatalogFactoryUrl(Config config, ClassLoader classLoader) {
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig(config);
        Map catalogOptions = readonlyConfig.getOptional(CatalogOptions.CATALOG_OPTIONS).orElse(new HashMap());
        String factoryId = catalogOptions.getOrDefault(CommonOptions.FACTORY_ID.key(), readonlyConfig.get(CommonOptions.PLUGIN_NAME));
        Optional<CatalogFactory> optionalFactory = FactoryUtil.discoverOptionalFactory(classLoader, CatalogFactory.class, factoryId);
        return optionalFactory.map(FactoryUtil::getFactoryUrl);
    }

    private int getParallelism(ReadonlyConfig config) {
        return Math.max(1, config.getOptional(CommonOptions.PARALLELISM).orElse(this.envOptions.get(CommonOptions.PARALLELISM)));
    }

    public List<SinkAction<?, ?, ?, ?>> parserSink(int configIndex, Config sinkConfig, ClassLoader classLoader, Map<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap) {
        Map<TablePath, CatalogTable> tableMap = CatalogTableUtil.getCatalogTables(sinkConfig, classLoader).stream().collect(Collectors.toMap(catalogTable -> catalogTable.getTableId().toTablePath(), catalogTable -> catalogTable));
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig(sinkConfig);
        String factoryId = MultipleTableJobConfigParser.getFactoryId(readonlyConfig);
        String leftTableId = readonlyConfig.getOptional(CommonOptions.SOURCE_TABLE_NAME).orElse("default");
        List<Tuple2<CatalogTable, Action>> tableTuples = tableWithActionMap.get(leftTableId);
        HashSet<URL> factoryUrls = new HashSet<URL>();
        URL factoryUrl = FactoryUtil.getFactoryUrl(FactoryUtil.discoverFactory(classLoader, TableSinkFactory.class, factoryId));
        factoryUrls.add(factoryUrl);
        MultipleTableJobConfigParser.getCatalogFactoryUrl(sinkConfig, classLoader).ifPresent(factoryUrls::add);
        ArrayList sinkActions = new ArrayList();
        for (Tuple2<CatalogTable, Action> tableTuple : tableTuples) {
            CatalogTable catalogTable2 = tableTuple._1();
            Action leftAction = tableTuple._2();
            Optional<CatalogTable> insteadTable = this.parsingMode == ParsingMode.SHARDING ? tableMap.values().stream().findFirst() : Optional.ofNullable(tableMap.get(catalogTable2.getTableId().toTablePath()));
            if (insteadTable.isPresent()) {
                catalogTable2 = insteadTable.get();
            }
            SeaTunnelSink sink = FactoryUtil.createAndPrepareSink(catalogTable2, readonlyConfig, classLoader, factoryId);
            SinkConfig actionConfig = new SinkConfig(catalogTable2.getTableId().toTablePath().toString());
            long id = this.idGenerator.getNextId();
            String actionName = JobConfigParser.createSinkActionName(configIndex, factoryId, String.format("%s(%s)", leftTableId, actionConfig.getMultipleRowTableId()));
            SinkAction sinkAction = new SinkAction(id, actionName, Collections.singletonList(leftAction), sink, factoryUrls, actionConfig);
            MultipleTableJobConfigParser.handleSaveMode(sink);
            sinkAction.setParallelism(leftAction.getParallelism());
            sinkActions.add(sinkAction);
        }
        return sinkActions;
    }

    private static void handleSaveMode(SeaTunnelSink<?, ?, ?, ?> sink) {
        if (SupportDataSaveMode.class.isAssignableFrom(sink.getClass())) {
            SupportDataSaveMode saveModeSink = (SupportDataSaveMode)((Object)sink);
            DataSaveMode dataSaveMode = saveModeSink.getDataSaveMode();
            saveModeSink.handleSaveMode(dataSaveMode);
        }
    }

    private static String getFactoryId(ReadonlyConfig readonlyConfig) {
        return readonlyConfig.getOptional(CommonOptions.FACTORY_ID).orElse(readonlyConfig.get(CommonOptions.PLUGIN_NAME));
    }
}

