/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.parse;

import com.google.common.collect.Lists;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SupportDataSaveMode;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.PartitionSeaTunnelTransform;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.core.starter.utils.ConfigBuilder;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.exception.JobDefineCheckException;
import org.apache.seatunnel.engine.common.loader.SeaTunnelChildFirstClassLoader;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.actions.AbstractAction;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.core.dag.actions.TransformAction;
import org.apache.seatunnel.engine.core.parse.ConnectorInstanceLoader;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import scala.Serializable;

public class JobConfigParser {
    private static final ILogger LOGGER = Logger.getLogger(JobConfigParser.class);
    private String jobDefineFilePath;
    private IdGenerator idGenerator;
    private Map<Action, String> alreadyTransformActionMap = new HashMap<Action, String>();
    private Map<String, List<Config>> transformResultTableNameMap = new HashMap<String, List<Config>>();
    private Map<String, List<Config>> transformSourceTableNameMap = new HashMap<String, List<Config>>();
    private Map<String, List<Config>> sourceResultTableNameMap = new HashMap<String, List<Config>>();
    private List<Action> actions = new ArrayList<Action>();
    private Set<URL> jarUrlsSet = new HashSet<URL>();
    private JobConfig jobConfig;
    private Config seaTunnelJobConfig;
    private Config envConfigs;
    private List<URL> commonPluginJars;

    public JobConfigParser(@NonNull String jobDefineFilePath, @NonNull IdGenerator idGenerator, @NonNull JobConfig jobConfig) {
        this(jobDefineFilePath, idGenerator, jobConfig, Collections.emptyList());
        if (jobDefineFilePath == null) {
            throw new NullPointerException("jobDefineFilePath is marked non-null but is null");
        }
        if (idGenerator == null) {
            throw new NullPointerException("idGenerator is marked non-null but is null");
        }
        if (jobConfig == null) {
            throw new NullPointerException("jobConfig is marked non-null but is null");
        }
    }

    public JobConfigParser(@NonNull String jobDefineFilePath, @NonNull IdGenerator idGenerator, @NonNull JobConfig jobConfig, @NonNull List<URL> commonPluginJars) {
        if (jobDefineFilePath == null) {
            throw new NullPointerException("jobDefineFilePath is marked non-null but is null");
        }
        if (idGenerator == null) {
            throw new NullPointerException("idGenerator is marked non-null but is null");
        }
        if (jobConfig == null) {
            throw new NullPointerException("jobConfig is marked non-null but is null");
        }
        if (commonPluginJars == null) {
            throw new NullPointerException("commonPluginJars is marked non-null but is null");
        }
        this.jobDefineFilePath = jobDefineFilePath;
        this.idGenerator = idGenerator;
        this.jobConfig = jobConfig;
        this.seaTunnelJobConfig = ConfigBuilder.of(Paths.get(jobDefineFilePath, new String[0]));
        this.envConfigs = this.seaTunnelJobConfig.getConfig("env");
        this.commonPluginJars = commonPluginJars;
    }

    public ImmutablePair<List<Action>, Set<URL>> parse() {
        Thread.currentThread().setContextClassLoader(new SeaTunnelChildFirstClassLoader(new ArrayList<URL>()));
        List<? extends Config> sinkConfigs = this.seaTunnelJobConfig.getConfigList("sink");
        List<? extends Config> transformConfigs = TypesafeConfigUtils.getConfigList(this.seaTunnelJobConfig, "transform", Collections.emptyList());
        List<? extends Config> sourceConfigs = this.seaTunnelJobConfig.getConfigList("source");
        if (CollectionUtils.isEmpty(sinkConfigs) || CollectionUtils.isEmpty(sourceConfigs)) {
            throw new JobDefineCheckException("Source And Sink can not be null");
        }
        this.jobConfigAnalyze(this.envConfigs);
        if (sinkConfigs.size() == 1 && sourceConfigs.size() == 1 && (CollectionUtils.isEmpty(transformConfigs) || transformConfigs.size() == 1)) {
            this.sampleAnalyze(sourceConfigs, transformConfigs, sinkConfigs);
        } else {
            this.complexAnalyze(sourceConfigs, transformConfigs, sinkConfigs);
        }
        this.actions.forEach(this::addCommonPluginJarsToAction);
        this.jarUrlsSet.addAll(this.commonPluginJars);
        return new ImmutablePair<List<Action>, Set<URL>>(this.actions, this.jarUrlsSet);
    }

    private void addCommonPluginJarsToAction(Action action) {
        action.getJarUrls().addAll(this.commonPluginJars);
        if (!action.getUpstream().isEmpty()) {
            action.getUpstream().forEach(this::addCommonPluginJarsToAction);
        }
    }

    void jobConfigAnalyze(@NonNull Config envConfigs) {
        if (envConfigs == null) {
            throw new NullPointerException("envConfigs is marked non-null but is null");
        }
        if (envConfigs.hasPath(EnvCommonOptions.JOB_MODE.key())) {
            this.jobConfig.getJobContext().setJobMode(envConfigs.getEnum(JobMode.class, EnvCommonOptions.JOB_MODE.key()));
        } else {
            this.jobConfig.getJobContext().setJobMode(EnvCommonOptions.JOB_MODE.defaultValue());
        }
        if (StringUtils.isEmpty(this.jobConfig.getName()) || this.jobConfig.getName().equals("SeaTunnel")) {
            if (envConfigs.hasPath(EnvCommonOptions.JOB_NAME.key())) {
                this.jobConfig.setName(envConfigs.getString(EnvCommonOptions.JOB_NAME.key()));
            } else {
                this.jobConfig.setName(EnvCommonOptions.JOB_NAME.defaultValue());
            }
        }
        if (envConfigs.hasPath(EnvCommonOptions.CHECKPOINT_INTERVAL.key())) {
            this.jobConfig.getEnvOptions().put(EnvCommonOptions.CHECKPOINT_INTERVAL.key(), envConfigs.getLong(EnvCommonOptions.CHECKPOINT_INTERVAL.key()));
        }
    }

    private void complexAnalyze(List<? extends Config> sourceConfigs, List<? extends Config> transformConfigs, List<? extends Config> sinkConfigs) {
        this.initRelationMap(sourceConfigs, transformConfigs);
        for (int configIndex = 0; configIndex < sinkConfigs.size(); ++configIndex) {
            SeaTunnelDataType<?> dataType;
            Config config = sinkConfigs.get(configIndex);
            ImmutablePair<SeaTunnelSink<SeaTunnelRow, Serializable, Serializable, Serializable>, Set<URL>> sinkListImmutablePair = ConnectorInstanceLoader.loadSinkInstance(config, this.jobConfig.getJobContext(), this.commonPluginJars);
            String sinkActionName = JobConfigParser.createSinkActionName(configIndex, sinkListImmutablePair.getLeft().getPluginName(), JobConfigParser.getTableName(config));
            SinkAction sinkAction = this.createSinkAction(this.idGenerator.getNextId(), sinkActionName, sinkListImmutablePair.getLeft(), sinkListImmutablePair.getRight());
            this.actions.add(sinkAction);
            if (!config.hasPath(CommonOptions.SOURCE_TABLE_NAME.key())) {
                throw new JobDefineCheckException(CommonOptions.SOURCE_TABLE_NAME + " must be set in the sink plugin config when the job have complex dependencies");
            }
            String sourceTableName = config.getString(CommonOptions.SOURCE_TABLE_NAME.key());
            List<Config> transformConfigList = this.transformResultTableNameMap.get(sourceTableName);
            if (CollectionUtils.isEmpty(transformConfigList)) {
                dataType = this.sourceAnalyze(sourceTableName, sinkAction);
            } else {
                if (transformConfigList.size() > 1) {
                    throw new JobDefineCheckException("Only UnionTransform can have more than one upstream, " + sinkAction.getName() + " is not UnionTransform Connector");
                }
                dataType = this.transformAnalyze(sourceTableName, sinkAction);
            }
            SeaTunnelSink<SeaTunnelRow, Serializable, Serializable, Serializable> seaTunnelSink = sinkListImmutablePair.getLeft();
            seaTunnelSink.setTypeInfo((SeaTunnelRowType)dataType);
            if (!SupportDataSaveMode.class.isAssignableFrom(seaTunnelSink.getClass())) continue;
            SupportDataSaveMode saveModeSink = (SupportDataSaveMode)((Object)seaTunnelSink);
            DataSaveMode dataSaveMode = saveModeSink.getDataSaveMode();
            saveModeSink.handleSaveMode(dataSaveMode);
        }
    }

    private SeaTunnelDataType sourceAnalyze(String sourceTableName, Action action) {
        List<Config> sourceConfigList = this.sourceResultTableNameMap.get(sourceTableName);
        if (CollectionUtils.isEmpty(sourceConfigList)) {
            throw new JobDefineCheckException(action.getName() + " source table name [" + sourceTableName + "] can not be found");
        }
        SeaTunnelDataType dataType = null;
        AtomicInteger totalParallelism = new AtomicInteger();
        for (int configIndex = 0; configIndex < sourceConfigList.size(); ++configIndex) {
            Config sourceConfig = sourceConfigList.get(configIndex);
            ImmutablePair<SeaTunnelSource, Set<URL>> seaTunnelSourceListImmutablePair = ConnectorInstanceLoader.loadSourceInstance(sourceConfig, this.jobConfig.getJobContext(), this.commonPluginJars);
            dataType = seaTunnelSourceListImmutablePair.getLeft().getProducedType();
            String sourceActionName = JobConfigParser.createSourceActionName(configIndex, sourceConfig.getString("plugin_name"), JobConfigParser.getTableName(sourceConfig));
            SourceAction sourceAction = this.createSourceAction(this.idGenerator.getNextId(), sourceActionName, seaTunnelSourceListImmutablePair.getLeft(), seaTunnelSourceListImmutablePair.getRight());
            int sourceParallelism = this.getSourceParallelism(sourceConfig);
            sourceAction.setParallelism(sourceParallelism);
            totalParallelism.set(totalParallelism.get() + sourceParallelism);
            action.addUpstream(sourceAction);
            action.setParallelism(totalParallelism.get());
        }
        return dataType;
    }

    private SeaTunnelDataType<?> transformAnalyze(String sourceTableName, Action action) {
        List<Config> transformConfigList = this.transformResultTableNameMap.get(sourceTableName);
        if (CollectionUtils.isEmpty(transformConfigList)) {
            return this.sourceAnalyze(sourceTableName, action);
        }
        AtomicInteger totalParallelism = new AtomicInteger();
        SeaTunnelDataType<?> dataTypeResult = null;
        for (int configIndex = 0; configIndex < transformConfigList.size(); ++configIndex) {
            Config config = transformConfigList.get(configIndex);
            ImmutablePair<SeaTunnelTransform<?>, Set<URL>> transformListImmutablePair = ConnectorInstanceLoader.loadTransformInstance(config, this.jobConfig.getJobContext(), this.commonPluginJars);
            String transformActionName = JobConfigParser.createTransformActionName(configIndex, transformListImmutablePair.getLeft().getPluginName(), JobConfigParser.getTableName(config));
            TransformAction transformAction = this.createTransformAction(this.idGenerator.getNextId(), transformActionName, transformListImmutablePair.getLeft(), transformListImmutablePair.getRight());
            action.addUpstream(transformAction);
            SeaTunnelDataType<?> dataType = this.transformAnalyze(config.getString(CommonOptions.SOURCE_TABLE_NAME.key()), transformAction);
            transformListImmutablePair.getLeft().setTypeInfo(dataType);
            dataTypeResult = transformListImmutablePair.getLeft().getProducedType();
            totalParallelism.set(totalParallelism.get() + transformAction.getParallelism());
            action.setParallelism(totalParallelism.get());
        }
        return dataTypeResult;
    }

    private void initRelationMap(List<? extends Config> sourceConfigs, List<? extends Config> transformConfigs) {
        String resultTableName;
        for (Config config : sourceConfigs) {
            if (!config.hasPath(CommonOptions.RESULT_TABLE_NAME.key())) {
                throw new JobDefineCheckException(CommonOptions.RESULT_TABLE_NAME.key() + " must be set in the source plugin config when the job have complex dependencies");
            }
            resultTableName = config.getString(CommonOptions.RESULT_TABLE_NAME.key());
            this.sourceResultTableNameMap.computeIfAbsent(resultTableName, k -> new ArrayList());
            this.sourceResultTableNameMap.get(resultTableName).add(config);
        }
        for (Config config : transformConfigs) {
            if (!config.hasPath(CommonOptions.RESULT_TABLE_NAME.key())) {
                throw new JobDefineCheckException(CommonOptions.RESULT_TABLE_NAME.key() + " must be set in the transform plugin config when the job have complex dependencies");
            }
            if (!config.hasPath(CommonOptions.SOURCE_TABLE_NAME.key())) {
                throw new JobDefineCheckException(CommonOptions.SOURCE_TABLE_NAME.key() + " must be set in the transform plugin config when the job have complex dependencies");
            }
            resultTableName = config.getString(CommonOptions.RESULT_TABLE_NAME.key());
            String sourceTableName = config.getString(CommonOptions.SOURCE_TABLE_NAME.key());
            if (Objects.equals(sourceTableName, resultTableName)) {
                throw new JobDefineCheckException(String.format("Source{%s} and result{%s} table name cannot be equals", sourceTableName, resultTableName));
            }
            this.transformResultTableNameMap.computeIfAbsent(resultTableName, k -> new ArrayList());
            this.transformResultTableNameMap.get(resultTableName).add(config);
            this.transformSourceTableNameMap.computeIfAbsent(sourceTableName, k -> new ArrayList());
            this.transformSourceTableNameMap.get(sourceTableName).add(config);
        }
    }

    private void sampleAnalyze(List<? extends Config> sourceConfigs, List<? extends Config> transformConfigs, List<? extends Config> sinkConfigs) {
        ImmutablePair<SeaTunnelSource, Set<URL>> pair = ConnectorInstanceLoader.loadSourceInstance(sourceConfigs.get(0), this.jobConfig.getJobContext(), this.commonPluginJars);
        String sourceActionName = JobConfigParser.createSourceActionName(0, pair.getLeft().getPluginName(), "default");
        SourceAction sourceAction = this.createSourceAction(this.idGenerator.getNextId(), sourceActionName, pair.getLeft(), pair.getRight());
        sourceAction.setParallelism(this.getSourceParallelism(sourceConfigs.get(0)));
        SeaTunnelDataType<Object> dataType = sourceAction.getSource().getProducedType();
        AbstractAction sinkUpstreamAction = sourceAction;
        if (!CollectionUtils.isEmpty(transformConfigs)) {
            ImmutablePair<SeaTunnelTransform<?>, Set<URL>> transformListImmutablePair = ConnectorInstanceLoader.loadTransformInstance(transformConfigs.get(0), this.jobConfig.getJobContext(), this.commonPluginJars);
            transformListImmutablePair.getLeft().setTypeInfo(dataType);
            dataType = transformListImmutablePair.getLeft().getProducedType();
            String transformActionName = JobConfigParser.createTransformActionName(0, transformListImmutablePair.getLeft().getPluginName(), "default");
            TransformAction transformAction = this.createTransformAction(this.idGenerator.getNextId(), transformActionName, Lists.newArrayList(sourceAction), transformListImmutablePair.getLeft(), transformListImmutablePair.getRight());
            this.initTransformParallelism(transformConfigs, sourceAction, transformListImmutablePair.getLeft(), transformAction);
            sinkUpstreamAction = transformAction;
        }
        ImmutablePair<SeaTunnelSink<SeaTunnelRow, Serializable, Serializable, Serializable>, Set<URL>> sinkListImmutablePair = ConnectorInstanceLoader.loadSinkInstance(sinkConfigs.get(0), this.jobConfig.getJobContext(), this.commonPluginJars);
        String sinkActionName = JobConfigParser.createSinkActionName(0, sinkListImmutablePair.getLeft().getPluginName(), "default");
        SinkAction sinkAction = this.createSinkAction(this.idGenerator.getNextId(), sinkActionName, Lists.newArrayList(sinkUpstreamAction), sinkListImmutablePair.getLeft(), sinkListImmutablePair.getRight());
        SeaTunnelSink seaTunnelSink = sinkAction.getSink();
        seaTunnelSink.setTypeInfo((SeaTunnelRowType)dataType);
        sinkAction.setParallelism(sinkUpstreamAction.getParallelism());
        if (SupportDataSaveMode.class.isAssignableFrom(seaTunnelSink.getClass())) {
            SupportDataSaveMode saveModeSink = (SupportDataSaveMode)((Object)seaTunnelSink);
            DataSaveMode dataSaveMode = saveModeSink.getDataSaveMode();
            saveModeSink.handleSaveMode(dataSaveMode);
        }
        this.actions.add(sinkAction);
    }

    private void initTransformParallelism(List<? extends Config> transformConfigs, Action upstreamAction, SeaTunnelTransform seaTunnelTransform, TransformAction transformAction) {
        if (seaTunnelTransform instanceof PartitionSeaTunnelTransform && transformConfigs.get(0).hasPath(CommonOptions.PARALLELISM.key())) {
            transformAction.setParallelism(transformConfigs.get(0).getInt(CommonOptions.PARALLELISM.key()));
        } else {
            transformAction.setParallelism(upstreamAction.getParallelism());
        }
    }

    private int getSourceParallelism(Config sourceConfig) {
        if (sourceConfig.hasPath(CommonOptions.PARALLELISM.key())) {
            int sourceParallelism = sourceConfig.getInt(CommonOptions.PARALLELISM.key());
            return Math.max(sourceParallelism, 1);
        }
        int executionParallelism = 0;
        if (this.envConfigs.hasPath(CommonOptions.PARALLELISM.key())) {
            executionParallelism = this.envConfigs.getInt(CommonOptions.PARALLELISM.key());
        }
        return Math.max(executionParallelism, 1);
    }

    private SourceAction createSourceAction(long id, @NonNull String name, @NonNull SeaTunnelSource source, Set<URL> jarUrls) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (!CollectionUtils.isEmpty(jarUrls)) {
            this.jarUrlsSet.addAll(jarUrls);
        }
        return new SourceAction(id, name, source, jarUrls);
    }

    private TransformAction createTransformAction(long id, @NonNull String name, @NonNull List<Action> upstreams, @NonNull SeaTunnelTransform transformation, Set<URL> jarUrls) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (upstreams == null) {
            throw new NullPointerException("upstreams is marked non-null but is null");
        }
        if (transformation == null) {
            throw new NullPointerException("transformation is marked non-null but is null");
        }
        if (!CollectionUtils.isEmpty(jarUrls)) {
            this.jarUrlsSet.addAll(jarUrls);
        }
        return new TransformAction(id, name, upstreams, transformation, jarUrls);
    }

    private SinkAction createSinkAction(long id, @NonNull String name, @NonNull List<Action> upstreams, @NonNull SeaTunnelSink sink, Set<URL> jarUrls) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (upstreams == null) {
            throw new NullPointerException("upstreams is marked non-null but is null");
        }
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        if (!CollectionUtils.isEmpty(jarUrls)) {
            this.jarUrlsSet.addAll(jarUrls);
        }
        return new SinkAction(id, name, upstreams, sink, jarUrls);
    }

    private TransformAction createTransformAction(long id, @NonNull String name, @NonNull SeaTunnelTransform transformation, Set<URL> jarUrls) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (transformation == null) {
            throw new NullPointerException("transformation is marked non-null but is null");
        }
        if (!CollectionUtils.isEmpty(jarUrls)) {
            this.jarUrlsSet.addAll(jarUrls);
        }
        return new TransformAction(id, name, transformation, jarUrls);
    }

    private SinkAction createSinkAction(long id, @NonNull String name, @NonNull SeaTunnelSink sink, Set<URL> jarUrls) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (sink == null) {
            throw new NullPointerException("sink is marked non-null but is null");
        }
        if (!CollectionUtils.isEmpty(jarUrls)) {
            this.jarUrlsSet.addAll(jarUrls);
        }
        return new SinkAction(id, name, sink, jarUrls);
    }

    static String createSourceActionName(int configIndex, String pluginName, String tableName) {
        return String.format("Source[%s]-%s-%s", configIndex, pluginName, tableName);
    }

    static String createSinkActionName(int configIndex, String pluginName, String tableName) {
        return String.format("Sink[%s]-%s-%s", configIndex, pluginName, tableName);
    }

    static String createTransformActionName(int configIndex, String pluginName, String tableName) {
        return String.format("Transform[%s]-%s-%s", configIndex, pluginName, tableName);
    }

    static String getTableName(Config config) {
        return JobConfigParser.getTableName(config, "default");
    }

    static String getTableName(Config config, String defaultValue) {
        String sourceTableName = null;
        if (config.hasPath(CommonOptions.SOURCE_TABLE_NAME.key())) {
            sourceTableName = config.getString(CommonOptions.SOURCE_TABLE_NAME.key());
        }
        String resultTableName = null;
        if (config.hasPath(CommonOptions.RESULT_TABLE_NAME.key())) {
            resultTableName = config.getString(CommonOptions.RESULT_TABLE_NAME.key());
        }
        if (sourceTableName != null && resultTableName != null) {
            return String.format("%s_%s", sourceTableName, resultTableName);
        }
        if (sourceTableName == null) {
            return resultTableName;
        }
        if (resultTableName == null) {
            return sourceTableName;
        }
        return defaultValue;
    }

    public String getJobDefineFilePath() {
        return this.jobDefineFilePath;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public Map<Action, String> getAlreadyTransformActionMap() {
        return this.alreadyTransformActionMap;
    }

    public Map<String, List<Config>> getTransformResultTableNameMap() {
        return this.transformResultTableNameMap;
    }

    public Map<String, List<Config>> getTransformSourceTableNameMap() {
        return this.transformSourceTableNameMap;
    }

    public Map<String, List<Config>> getSourceResultTableNameMap() {
        return this.sourceResultTableNameMap;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public Set<URL> getJarUrlsSet() {
        return this.jarUrlsSet;
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    public Config getSeaTunnelJobConfig() {
        return this.seaTunnelJobConfig;
    }

    public Config getEnvConfigs() {
        return this.envConfigs;
    }

    public List<URL> getCommonPluginJars() {
        return this.commonPluginJars;
    }

    public void setJobDefineFilePath(String jobDefineFilePath) {
        this.jobDefineFilePath = jobDefineFilePath;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setAlreadyTransformActionMap(Map<Action, String> alreadyTransformActionMap) {
        this.alreadyTransformActionMap = alreadyTransformActionMap;
    }

    public void setTransformResultTableNameMap(Map<String, List<Config>> transformResultTableNameMap) {
        this.transformResultTableNameMap = transformResultTableNameMap;
    }

    public void setTransformSourceTableNameMap(Map<String, List<Config>> transformSourceTableNameMap) {
        this.transformSourceTableNameMap = transformSourceTableNameMap;
    }

    public void setSourceResultTableNameMap(Map<String, List<Config>> sourceResultTableNameMap) {
        this.sourceResultTableNameMap = sourceResultTableNameMap;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public void setJarUrlsSet(Set<URL> jarUrlsSet) {
        this.jarUrlsSet = jarUrlsSet;
    }

    public void setJobConfig(JobConfig jobConfig) {
        this.jobConfig = jobConfig;
    }

    public void setSeaTunnelJobConfig(Config seaTunnelJobConfig) {
        this.seaTunnelJobConfig = seaTunnelJobConfig;
    }

    public void setEnvConfigs(Config envConfigs) {
        this.envConfigs = envConfigs;
    }

    public void setCommonPluginJars(List<URL> commonPluginJars) {
        this.commonPluginJars = commonPluginJars;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobConfigParser)) {
            return false;
        }
        JobConfigParser other = (JobConfigParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jobDefineFilePath = this.getJobDefineFilePath();
        String other$jobDefineFilePath = other.getJobDefineFilePath();
        if (this$jobDefineFilePath == null ? other$jobDefineFilePath != null : !this$jobDefineFilePath.equals(other$jobDefineFilePath)) {
            return false;
        }
        IdGenerator this$idGenerator = this.getIdGenerator();
        IdGenerator other$idGenerator = other.getIdGenerator();
        if (this$idGenerator == null ? other$idGenerator != null : !this$idGenerator.equals(other$idGenerator)) {
            return false;
        }
        Map<Action, String> this$alreadyTransformActionMap = this.getAlreadyTransformActionMap();
        Map<Action, String> other$alreadyTransformActionMap = other.getAlreadyTransformActionMap();
        if (this$alreadyTransformActionMap == null ? other$alreadyTransformActionMap != null : !((Object)this$alreadyTransformActionMap).equals(other$alreadyTransformActionMap)) {
            return false;
        }
        Map<String, List<Config>> this$transformResultTableNameMap = this.getTransformResultTableNameMap();
        Map<String, List<Config>> other$transformResultTableNameMap = other.getTransformResultTableNameMap();
        if (this$transformResultTableNameMap == null ? other$transformResultTableNameMap != null : !((Object)this$transformResultTableNameMap).equals(other$transformResultTableNameMap)) {
            return false;
        }
        Map<String, List<Config>> this$transformSourceTableNameMap = this.getTransformSourceTableNameMap();
        Map<String, List<Config>> other$transformSourceTableNameMap = other.getTransformSourceTableNameMap();
        if (this$transformSourceTableNameMap == null ? other$transformSourceTableNameMap != null : !((Object)this$transformSourceTableNameMap).equals(other$transformSourceTableNameMap)) {
            return false;
        }
        Map<String, List<Config>> this$sourceResultTableNameMap = this.getSourceResultTableNameMap();
        Map<String, List<Config>> other$sourceResultTableNameMap = other.getSourceResultTableNameMap();
        if (this$sourceResultTableNameMap == null ? other$sourceResultTableNameMap != null : !((Object)this$sourceResultTableNameMap).equals(other$sourceResultTableNameMap)) {
            return false;
        }
        List<Action> this$actions = this.getActions();
        List<Action> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        Set<URL> this$jarUrlsSet = this.getJarUrlsSet();
        Set<URL> other$jarUrlsSet = other.getJarUrlsSet();
        if (this$jarUrlsSet == null ? other$jarUrlsSet != null : !((Object)this$jarUrlsSet).equals(other$jarUrlsSet)) {
            return false;
        }
        JobConfig this$jobConfig = this.getJobConfig();
        JobConfig other$jobConfig = other.getJobConfig();
        if (this$jobConfig == null ? other$jobConfig != null : !((Object)this$jobConfig).equals(other$jobConfig)) {
            return false;
        }
        Config this$seaTunnelJobConfig = this.getSeaTunnelJobConfig();
        Config other$seaTunnelJobConfig = other.getSeaTunnelJobConfig();
        if (this$seaTunnelJobConfig == null ? other$seaTunnelJobConfig != null : !this$seaTunnelJobConfig.equals(other$seaTunnelJobConfig)) {
            return false;
        }
        Config this$envConfigs = this.getEnvConfigs();
        Config other$envConfigs = other.getEnvConfigs();
        if (this$envConfigs == null ? other$envConfigs != null : !this$envConfigs.equals(other$envConfigs)) {
            return false;
        }
        List<URL> this$commonPluginJars = this.getCommonPluginJars();
        List<URL> other$commonPluginJars = other.getCommonPluginJars();
        return !(this$commonPluginJars == null ? other$commonPluginJars != null : !((Object)this$commonPluginJars).equals(other$commonPluginJars));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobConfigParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $jobDefineFilePath = this.getJobDefineFilePath();
        result2 = result2 * 59 + ($jobDefineFilePath == null ? 43 : $jobDefineFilePath.hashCode());
        IdGenerator $idGenerator = this.getIdGenerator();
        result2 = result2 * 59 + ($idGenerator == null ? 43 : $idGenerator.hashCode());
        Map<Action, String> $alreadyTransformActionMap = this.getAlreadyTransformActionMap();
        result2 = result2 * 59 + ($alreadyTransformActionMap == null ? 43 : ((Object)$alreadyTransformActionMap).hashCode());
        Map<String, List<Config>> $transformResultTableNameMap = this.getTransformResultTableNameMap();
        result2 = result2 * 59 + ($transformResultTableNameMap == null ? 43 : ((Object)$transformResultTableNameMap).hashCode());
        Map<String, List<Config>> $transformSourceTableNameMap = this.getTransformSourceTableNameMap();
        result2 = result2 * 59 + ($transformSourceTableNameMap == null ? 43 : ((Object)$transformSourceTableNameMap).hashCode());
        Map<String, List<Config>> $sourceResultTableNameMap = this.getSourceResultTableNameMap();
        result2 = result2 * 59 + ($sourceResultTableNameMap == null ? 43 : ((Object)$sourceResultTableNameMap).hashCode());
        List<Action> $actions = this.getActions();
        result2 = result2 * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        Set<URL> $jarUrlsSet = this.getJarUrlsSet();
        result2 = result2 * 59 + ($jarUrlsSet == null ? 43 : ((Object)$jarUrlsSet).hashCode());
        JobConfig $jobConfig = this.getJobConfig();
        result2 = result2 * 59 + ($jobConfig == null ? 43 : ((Object)$jobConfig).hashCode());
        Config $seaTunnelJobConfig = this.getSeaTunnelJobConfig();
        result2 = result2 * 59 + ($seaTunnelJobConfig == null ? 43 : $seaTunnelJobConfig.hashCode());
        Config $envConfigs = this.getEnvConfigs();
        result2 = result2 * 59 + ($envConfigs == null ? 43 : $envConfigs.hashCode());
        List<URL> $commonPluginJars = this.getCommonPluginJars();
        result2 = result2 * 59 + ($commonPluginJars == null ? 43 : ((Object)$commonPluginJars).hashCode());
        return result2;
    }

    public String toString() {
        return "JobConfigParser(jobDefineFilePath=" + this.getJobDefineFilePath() + ", idGenerator=" + this.getIdGenerator() + ", alreadyTransformActionMap=" + this.getAlreadyTransformActionMap() + ", transformResultTableNameMap=" + this.getTransformResultTableNameMap() + ", transformSourceTableNameMap=" + this.getTransformSourceTableNameMap() + ", sourceResultTableNameMap=" + this.getSourceResultTableNameMap() + ", actions=" + this.getActions() + ", jarUrlsSet=" + this.getJarUrlsSet() + ", jobConfig=" + this.getJobConfig() + ", seaTunnelJobConfig=" + this.getSeaTunnelJobConfig() + ", envConfigs=" + this.getEnvConfigs() + ", commonPluginJars=" + this.getCommonPluginJars() + ")";
    }
}

