/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;

public class CatalogTableUtil
implements Serializable {
    public static final Option<Map<String, String>> SCHEMA = Options.key("schema").mapType().noDefaultValue().withDescription("SeaTunnel Schema");
    public static final Option<String> FIELDS = Options.key("schema.fields").stringType().noDefaultValue().withDescription("SeaTunnel Schema Fields");
    private static final String FIELD_KEY = "fields";
    private static final SeaTunnelRowType SIMPLE_SCHEMA = new SeaTunnelRowType(new String[]{"content"}, new SeaTunnelDataType[]{BasicType.STRING_TYPE});
    private final CatalogTable catalogTable;

    private CatalogTableUtil(CatalogTable catalogTable) {
        this.catalogTable = catalogTable;
    }

    public static List<CatalogTable> getCatalogTables(Config config, ClassLoader classLoader) {
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig(config);
        Map catalogOptions = readonlyConfig.getOptional(CatalogOptions.CATALOG_OPTIONS).orElse(new HashMap());
        String factoryId = catalogOptions.getOrDefault(CommonOptions.FACTORY_ID.key(), readonlyConfig.get(CommonOptions.PLUGIN_NAME));
        HashMap<String, Object> catalogAllOptions = new HashMap<String, Object>();
        catalogAllOptions.putAll(readonlyConfig.toMap());
        catalogAllOptions.putAll(catalogOptions);
        ReadonlyConfig catalogConfig = ReadonlyConfig.fromMap(catalogAllOptions);
        Map<String, String> schemaMap = readonlyConfig.get(SCHEMA);
        if (schemaMap != null && schemaMap.size() > 0) {
            CatalogTable catalogTable = CatalogTableUtil.buildWithConfig(config).getCatalogTable();
            return Collections.singletonList(catalogTable);
        }
        Optional<Catalog> optionalCatalog = FactoryUtil.createOptionalCatalog(catalogConfig.get(CatalogOptions.NAME), catalogConfig, classLoader, factoryId);
        if (!optionalCatalog.isPresent()) {
            return Collections.emptyList();
        }
        Catalog catalog = optionalCatalog.get();
        List<String> tableNames = catalogConfig.get(CatalogOptions.TABLE_NAMES);
        ArrayList<CatalogTable> catalogTables = new ArrayList<CatalogTable>();
        if (tableNames != null && tableNames.size() >= 1) {
            for (String tableName : tableNames) {
                catalogTables.add(catalog.getTable(TablePath.of(tableName)));
            }
            return catalogTables;
        }
        String tablePatternStr = catalogConfig.get(CatalogOptions.TABLE_PATTERN);
        if (StringUtils.isBlank(tablePatternStr)) {
            return Collections.emptyList();
        }
        Pattern databasePattern = Pattern.compile(catalogConfig.get(CatalogOptions.DATABASE_PATTERN));
        Pattern tablePattern = Pattern.compile(catalogConfig.get(CatalogOptions.TABLE_PATTERN));
        List<String> allDatabase = catalog.listDatabases();
        allDatabase.removeIf(s2 -> !databasePattern.matcher((CharSequence)s2).matches());
        for (String databaseName : allDatabase) {
            tableNames = catalog.listTables(databaseName);
            for (String tableName : tableNames) {
                if (!tablePattern.matcher(databaseName + "." + tableName).matches()) continue;
                catalogTables.add(catalog.getTable(TablePath.of(databaseName, tableName)));
            }
        }
        return catalogTables;
    }

    public static CatalogTableUtil buildWithConfig(Config config) {
        CheckResult checkResult = CheckConfigUtil.checkAllExists(config, "schema");
        if (!checkResult.isSuccess()) {
            throw new RuntimeException("Schema config need option [schema], please correct your config first");
        }
        TableSchema tableSchema = CatalogTableUtil.parseTableSchema(config.getConfig("schema"));
        return new CatalogTableUtil(CatalogTable.of(TableIdentifier.of("", "", ""), tableSchema, new HashMap<String, String>(), new ArrayList<String>(), ""));
    }

    public static SeaTunnelRowType buildSimpleTextSchema() {
        return SIMPLE_SCHEMA;
    }

    public SeaTunnelRowType getSeaTunnelRowType() {
        return this.catalogTable.getTableSchema().toPhysicalRowDataType();
    }

    public static SeaTunnelDataType<?> parseDataType(String columnStr) {
        columnStr = columnStr.toUpperCase().replace(" ", "");
        SqlType sqlType = null;
        try {
            sqlType = SqlType.valueOf(columnStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (sqlType == null) {
            return CatalogTableUtil.parseComplexDataType(columnStr);
        }
        switch (sqlType) {
            case STRING: {
                return BasicType.STRING_TYPE;
            }
            case BOOLEAN: {
                return BasicType.BOOLEAN_TYPE;
            }
            case TINYINT: {
                return BasicType.BYTE_TYPE;
            }
            case BYTES: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case SMALLINT: {
                return BasicType.SHORT_TYPE;
            }
            case INT: {
                return BasicType.INT_TYPE;
            }
            case BIGINT: {
                return BasicType.LONG_TYPE;
            }
            case FLOAT: {
                return BasicType.FLOAT_TYPE;
            }
            case DOUBLE: {
                return BasicType.DOUBLE_TYPE;
            }
            case NULL: {
                return BasicType.VOID_TYPE;
            }
            case DATE: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case TIME: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case TIMESTAMP: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
        }
        throw new UnsupportedOperationException(String.format("the type[%s] is not support", columnStr));
    }

    private static SeaTunnelDataType<?> parseComplexDataType(String columnStr) {
        if (columnStr.startsWith(SqlType.MAP.name())) {
            return CatalogTableUtil.parseMapType(columnStr);
        }
        if (columnStr.startsWith(SqlType.ARRAY.name())) {
            return CatalogTableUtil.parseArrayType(columnStr);
        }
        if (columnStr.startsWith(SqlType.DECIMAL.name())) {
            return CatalogTableUtil.parseDecimalType(columnStr);
        }
        return CatalogTableUtil.parseRowType(columnStr);
    }

    private static SeaTunnelDataType<?> parseRowType(String columnStr) {
        Map<String, String> fieldsMap = CatalogTableUtil.convertJsonToMap(columnStr);
        String[] fieldsName = new String[fieldsMap.size()];
        SeaTunnelDataType[] seaTunnelDataTypes = new SeaTunnelDataType[fieldsMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
            fieldsName[i] = entry.getKey();
            seaTunnelDataTypes[i] = CatalogTableUtil.parseDataType(entry.getValue());
            ++i;
        }
        return new SeaTunnelRowType(fieldsName, seaTunnelDataTypes);
    }

    private static SeaTunnelDataType<?> parseMapType(String columnStr) {
        String genericType = CatalogTableUtil.getGenericType(columnStr);
        int index = genericType.startsWith(SqlType.DECIMAL.name()) ? genericType.indexOf(",", genericType.indexOf(",") + 1) : genericType.indexOf(",");
        String keyGenericType = genericType.substring(0, index);
        String valueGenericType = genericType.substring(index + 1);
        return new MapType(CatalogTableUtil.parseDataType(keyGenericType), CatalogTableUtil.parseDataType(valueGenericType));
    }

    private static String getGenericType(String columnStr) {
        return columnStr.substring(columnStr.indexOf("<") + 1, columnStr.lastIndexOf(">"));
    }

    private static SeaTunnelDataType<?> parseArrayType(String columnStr) {
        String genericType = CatalogTableUtil.getGenericType(columnStr);
        SeaTunnelDataType<?> dataType = CatalogTableUtil.parseDataType(genericType);
        switch (dataType.getSqlType()) {
            case STRING: {
                return ArrayType.STRING_ARRAY_TYPE;
            }
            case BOOLEAN: {
                return ArrayType.BOOLEAN_ARRAY_TYPE;
            }
            case TINYINT: {
                return ArrayType.BYTE_ARRAY_TYPE;
            }
            case SMALLINT: {
                return ArrayType.SHORT_ARRAY_TYPE;
            }
            case INT: {
                return ArrayType.INT_ARRAY_TYPE;
            }
            case BIGINT: {
                return ArrayType.LONG_ARRAY_TYPE;
            }
            case FLOAT: {
                return ArrayType.FLOAT_ARRAY_TYPE;
            }
            case DOUBLE: {
                return ArrayType.DOUBLE_ARRAY_TYPE;
            }
        }
        String errorMsg = String.format("Array type not support this genericType [%s]", genericType);
        throw new UnsupportedOperationException(errorMsg);
    }

    private static SeaTunnelDataType<?> parseDecimalType(String columnStr) {
        String[] decimalInfos = columnStr.split(",");
        if (decimalInfos.length < 2) {
            throw new RuntimeException("Decimal type should assign precision and scale information");
        }
        int precision = Integer.parseInt(decimalInfos[0].replaceAll("\\D", ""));
        int scale = Integer.parseInt(decimalInfos[1].replaceAll("\\D", ""));
        return new DecimalType(precision, scale);
    }

    private static Map<String, String> convertConfigToMap(Config config) {
        ConfigRenderOptions options = ConfigRenderOptions.concise();
        String schema = config.root().render(options);
        return CatalogTableUtil.convertJsonToMap(schema);
    }

    private static Map<String, String> convertJsonToMap(String json) {
        ObjectNode jsonNodes = JsonUtils.parseObject(json);
        LinkedHashMap<String, String> fieldsMap = new LinkedHashMap<String, String>();
        jsonNodes.fields().forEachRemaining(field2 -> {
            String key = (String)field2.getKey();
            JsonNode value = (JsonNode)field2.getValue();
            if (value.getNodeType() == JsonNodeType.OBJECT) {
                fieldsMap.put(key, value.toString());
            } else {
                fieldsMap.put(key, value.textValue());
            }
        });
        return fieldsMap;
    }

    private static TableSchema parseTableSchema(Config config) {
        Map<String, String> fieldsMap = CatalogTableUtil.convertConfigToMap(config.getConfig(FIELD_KEY));
        int fieldsNum = fieldsMap.size();
        ArrayList<Column> columns = new ArrayList<Column>(fieldsNum);
        for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            SeaTunnelDataType<?> dataType = CatalogTableUtil.parseDataType(value);
            PhysicalColumn column = PhysicalColumn.of(key, dataType, 0, true, null, null);
            columns.add(column);
        }
        return TableSchema.builder().columns(columns).build();
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }
}

