/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteArrayInput;
import io.protostuff.CodedInput;
import io.protostuff.LimitedInputStream;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtobufException;
import io.protostuff.ProtobufOutput;
import io.protostuff.Schema;
import io.protostuff.UninitializedMessageException;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class IOUtil {
    private IOUtil() {
    }

    static <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) {
        try {
            ByteArrayInput input2 = new ByteArrayInput(data, offset, length, decodeNestedMessageAsGroup);
            schema.mergeFrom(input2, message);
            input2.checkLastTagWas(0);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new RuntimeException("Truncated.", ProtobufException.truncatedMessage(ae));
        }
        catch (IOException e) {
            throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", e);
        }
    }

    static <T> void mergeFrom(InputStream in, byte[] buf, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        CodedInput input2 = new CodedInput(in, buf, decodeNestedMessageAsGroup);
        schema.mergeFrom(input2, message);
        input2.checkLastTagWas(0);
    }

    static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        CodedInput input2 = new CodedInput(in, decodeNestedMessageAsGroup);
        schema.mergeFrom(input2, message);
        input2.checkLastTagWas(0);
    }

    static <T> int mergeDelimitedFrom(InputStream in, byte[] buf, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        int len;
        int size2 = in.read();
        if (size2 == -1) {
            throw new EOFException("mergeDelimitedFrom");
        }
        int n = len = size2 < 128 ? size2 : CodedInput.readRawVarint32(in, size2);
        if (len < 0) {
            throw ProtobufException.negativeSize();
        }
        if (len != 0) {
            if (len > buf.length) {
                throw new ProtobufException("size limit exceeded. " + len + " > " + buf.length);
            }
            IOUtil.fillBufferFrom(in, buf, 0, len);
            ByteArrayInput input2 = new ByteArrayInput(buf, 0, len, decodeNestedMessageAsGroup);
            try {
                schema.mergeFrom(input2, message);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ProtobufException.truncatedMessage(e);
            }
            input2.checkLastTagWas(0);
        }
        return len;
    }

    static <T> int mergeDelimitedFrom(InputStream in, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        int len;
        int size2 = in.read();
        if (size2 == -1) {
            throw new EOFException("mergeDelimitedFrom");
        }
        int n = len = size2 < 128 ? size2 : CodedInput.readRawVarint32(in, size2);
        if (len < 0) {
            throw ProtobufException.negativeSize();
        }
        if (len != 0) {
            if (len > 4096) {
                CodedInput input2 = new CodedInput(new LimitedInputStream(in, len), decodeNestedMessageAsGroup);
                schema.mergeFrom(input2, message);
                input2.checkLastTagWas(0);
                return len;
            }
            byte[] buf = new byte[len];
            IOUtil.fillBufferFrom(in, buf, 0, len);
            ByteArrayInput input3 = new ByteArrayInput(buf, 0, len, decodeNestedMessageAsGroup);
            try {
                schema.mergeFrom(input3, message);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ProtobufException.truncatedMessage(e);
            }
            input3.checkLastTagWas(0);
        }
        return len;
    }

    static <T> int mergeDelimitedFrom(DataInput in, T message, Schema<T> schema, boolean decodeNestedMessageAsGroup) throws IOException {
        int len;
        int size2 = in.readByte();
        int n = len = 0 == (size2 & 0x80) ? size2 : CodedInput.readRawVarint32(in, (byte)size2);
        if (len < 0) {
            throw ProtobufException.negativeSize();
        }
        if (len != 0) {
            if (len > 4096 && in instanceof InputStream) {
                CodedInput input2 = new CodedInput(new LimitedInputStream((InputStream)((Object)in), len), decodeNestedMessageAsGroup);
                schema.mergeFrom(input2, message);
                input2.checkLastTagWas(0);
            } else {
                byte[] buf = new byte[len];
                in.readFully(buf, 0, len);
                ByteArrayInput input3 = new ByteArrayInput(buf, 0, len, decodeNestedMessageAsGroup);
                try {
                    schema.mergeFrom(input3, message);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ProtobufException.truncatedMessage(e);
                }
                input3.checkLastTagWas(0);
            }
        }
        if (!schema.isInitialized(message)) {
            throw new UninitializedMessageException(message, schema);
        }
        return len;
    }

    static void fillBufferFrom(InputStream in, byte[] buf, int offset, int len) throws IOException {
        int read = 0;
        while (len > 0) {
            read = in.read(buf, offset, len);
            if (read == -1) {
                throw ProtobufException.truncatedMessage();
            }
            len -= read;
            offset += read;
        }
    }

    static int fillBufferWithDelimitedMessageFrom(InputStream in, boolean drainRemainingBytesIfTooLarge, LinkedBuffer lb) throws IOException {
        int size2;
        byte[] buf = lb.buffer;
        int offset = lb.start;
        int len = buf.length - offset;
        int read = in.read(buf, offset, len);
        if (read < 1) {
            throw new EOFException("fillBufferWithDelimitedMessageFrom");
        }
        int last2 = offset + read;
        if (0 != ((size2 = buf[offset++]) & 0x80)) {
            size2 &= 0x7F;
            int shift = 7;
            while (true) {
                block16: {
                    if (offset == last2) {
                        read = in.read(buf, last2, len - (last2 - lb.start));
                        if (read < 1) {
                            throw new EOFException("fillBufferWithDelimitedMessageFrom");
                        }
                        last2 += read;
                    }
                    byte b = buf[offset++];
                    size2 |= (b & 0x7F) << shift;
                    if (0 == (b & 0x80)) break;
                    if (shift == 28) {
                        int i = 0;
                        do {
                            if (offset == last2) {
                                read = in.read(buf, last2, len - (last2 - lb.start));
                                if (read < 1) {
                                    throw new EOFException("fillBufferWithDelimitedMessageFrom");
                                }
                                last2 += read;
                            }
                            if (buf[offset++] >= 0) break block16;
                        } while (5 != ++i);
                        throw ProtobufException.malformedVarint();
                    }
                }
                shift += 7;
            }
        }
        if (size2 == 0) {
            if (offset != last2) {
                throw ProtobufException.misreportedSize();
            }
            return size2;
        }
        if (size2 < 0) {
            throw ProtobufException.negativeSize();
        }
        int partial = last2 - offset;
        if (partial < size2) {
            int delimSize = offset - lb.start;
            if (size2 + delimSize > len) {
                if (!drainRemainingBytesIfTooLarge) {
                    return size2;
                }
                for (int remaining = size2 - partial; remaining > 0; remaining -= read) {
                    read = in.read(buf, lb.start, Math.min(remaining, len));
                    if (read >= 1) continue;
                    throw new EOFException("fillBufferWithDelimitedMessageFrom");
                }
                return size2;
            }
            IOUtil.fillBufferFrom(in, buf, last2, size2 - partial);
        }
        lb.offset = offset;
        return size2;
    }

    static int putVarInt32AndGetOffset(int value, byte[] buffer, int variableOffset) {
        switch (ProtobufOutput.computeRawVarint32Size(value)) {
            case 1: {
                buffer[variableOffset + 4] = (byte)value;
                return variableOffset + 4;
            }
            case 2: {
                buffer[variableOffset + 3] = (byte)(value & 0x7F | 0x80);
                buffer[variableOffset + 4] = (byte)(value >>> 7);
                return variableOffset + 3;
            }
            case 3: {
                buffer[variableOffset + 2] = (byte)(value & 0x7F | 0x80);
                buffer[variableOffset + 3] = (byte)(value >>> 7 & 0x7F | 0x80);
                buffer[variableOffset + 4] = (byte)(value >>> 14);
                return variableOffset + 2;
            }
            case 4: {
                buffer[variableOffset + 1] = (byte)(value & 0x7F | 0x80);
                buffer[variableOffset + 2] = (byte)(value >>> 7 & 0x7F | 0x80);
                buffer[variableOffset + 3] = (byte)(value >>> 14 & 0x7F | 0x80);
                buffer[variableOffset + 4] = (byte)(value >>> 21);
                return variableOffset + 1;
            }
        }
        buffer[variableOffset] = (byte)(value & 0x7F | 0x80);
        buffer[variableOffset + 1] = (byte)(value >>> 7 & 0x7F | 0x80);
        buffer[variableOffset + 2] = (byte)(value >>> 14 & 0x7F | 0x80);
        buffer[variableOffset + 3] = (byte)(value >>> 21 & 0x7F | 0x80);
        buffer[variableOffset + 4] = (byte)(value >>> 28);
        return variableOffset;
    }
}

