/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.logging.ILogger;

class TcpServerConnectionErrorHandler {
    private final ILogger logger;
    private final ServerContext serverContext;
    private final Address endpointAddress;
    private final long minInterval;
    private final int maxFaults;
    private int faults;
    private long lastFaultTime;

    TcpServerConnectionErrorHandler(ServerContext serverContext, Address endpointAddress) {
        this.endpointAddress = endpointAddress;
        this.serverContext = serverContext;
        this.minInterval = serverContext.getConnectionMonitorInterval();
        this.maxFaults = serverContext.getConnectionMonitorMaxFaults();
        this.logger = serverContext.getLoggingService().getLogger(this.getClass());
    }

    synchronized void onError(Throwable cause) {
        String errorMessage = "An error occurred on connection to " + this.endpointAddress + this.getCauseDescription(cause);
        this.logger.finest(errorMessage);
        long now = System.currentTimeMillis();
        long last2 = this.lastFaultTime;
        if (now - last2 > this.minInterval) {
            if (this.faults++ >= this.maxFaults) {
                String removeEndpointMessage = "Removing connection to endpoint " + this.endpointAddress + this.getCauseDescription(cause);
                this.logger.warning(removeEndpointMessage);
                this.serverContext.removeEndpoint(this.endpointAddress);
            }
            this.lastFaultTime = now;
        }
    }

    synchronized TcpServerConnectionErrorHandler reset() {
        String resetMessage = "Resetting connection monitor for endpoint " + this.endpointAddress;
        this.logger.finest(resetMessage);
        this.faults = 0;
        this.lastFaultTime = 0L;
        return this;
    }

    private String getCauseDescription(Throwable cause) {
        StringBuilder s2 = new StringBuilder(" Cause => ");
        if (cause != null) {
            s2.append(cause.getClass().getName()).append(" {").append(cause.getMessage()).append("}");
        } else {
            s2.append("Unknown");
        }
        return s2.append(", Error-Count: ").append(this.faults + 1).toString();
    }
}

