/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.security.AbstractClusterLoginConfig;
import com.hazelcast.config.security.LdapAuthenticationConfig;
import java.util.Objects;
import java.util.Properties;

public class KerberosAuthenticationConfig
extends AbstractClusterLoginConfig<KerberosAuthenticationConfig> {
    private Boolean relaxFlagsCheck;
    private Boolean useNameWithoutRealm;
    private String securityRealm;
    private String keytabFile;
    private String principal;
    private LdapAuthenticationConfig ldapAuthenticationConfig;

    public Boolean getRelaxFlagsCheck() {
        return this.relaxFlagsCheck;
    }

    public KerberosAuthenticationConfig setRelaxFlagsCheck(Boolean relaxFlagsCheck) {
        this.relaxFlagsCheck = relaxFlagsCheck;
        return this;
    }

    public String getSecurityRealm() {
        return this.securityRealm;
    }

    public KerberosAuthenticationConfig setUseNameWithoutRealm(Boolean useNameWithoutRealm) {
        this.useNameWithoutRealm = useNameWithoutRealm;
        return this;
    }

    public Boolean getUseNameWithoutRealm() {
        return this.useNameWithoutRealm;
    }

    public KerberosAuthenticationConfig setSecurityRealm(String securityRealm) {
        this.securityRealm = securityRealm;
        return this;
    }

    public LdapAuthenticationConfig getLdapAuthenticationConfig() {
        return this.ldapAuthenticationConfig;
    }

    public KerberosAuthenticationConfig setLdapAuthenticationConfig(LdapAuthenticationConfig ldapAuthenticationConfig) {
        this.ldapAuthenticationConfig = ldapAuthenticationConfig;
        return this;
    }

    public String getKeytabFile() {
        return this.keytabFile;
    }

    public KerberosAuthenticationConfig setKeytabFile(String keytabFile) {
        this.keytabFile = keytabFile;
        return this;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public KerberosAuthenticationConfig setPrincipal(String principal) {
        this.principal = principal;
        return this;
    }

    @Override
    protected Properties initLoginModuleProperties() {
        Properties props = super.initLoginModuleProperties();
        this.setIfConfigured(props, "relaxFlagsCheck", this.relaxFlagsCheck);
        this.setIfConfigured(props, "useNameWithoutRealm", this.useNameWithoutRealm);
        this.setIfConfigured(props, "securityRealm", this.securityRealm);
        this.setIfConfigured(props, "keytabFile", this.keytabFile);
        this.setIfConfigured(props, "principal", this.principal);
        return props;
    }

    @Override
    public LoginModuleConfig[] asLoginModuleConfigs() {
        LoginModuleConfig loginModuleConfig = new LoginModuleConfig("com.hazelcast.security.loginimpl.GssApiLoginModule", LoginModuleConfig.LoginModuleUsage.REQUIRED);
        loginModuleConfig.setProperties(this.initLoginModuleProperties());
        LoginModuleConfig[] loginModuleConfigs = null;
        if (this.ldapAuthenticationConfig != null) {
            loginModuleConfigs = new LoginModuleConfig[2];
            loginModuleConfigs[1] = this.ldapAuthenticationConfig.asLoginModuleConfigs()[0];
        } else {
            loginModuleConfigs = new LoginModuleConfig[]{loginModuleConfig};
        }
        return loginModuleConfigs;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + Objects.hash(this.ldapAuthenticationConfig, this.relaxFlagsCheck, this.useNameWithoutRealm, this.securityRealm, this.keytabFile, this.principal);
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KerberosAuthenticationConfig other = (KerberosAuthenticationConfig)obj;
        return Objects.equals(this.ldapAuthenticationConfig, other.ldapAuthenticationConfig) && Objects.equals(this.relaxFlagsCheck, other.relaxFlagsCheck) && Objects.equals(this.useNameWithoutRealm, other.useNameWithoutRealm) && Objects.equals(this.keytabFile, other.keytabFile) && Objects.equals(this.principal, other.principal) && Objects.equals(this.securityRealm, other.securityRealm);
    }

    public String toString() {
        return "KerberosAuthenticationConfig [relaxFlagsCheck=" + this.relaxFlagsCheck + ", securityRealm=" + this.securityRealm + ", useNameWithoutRealm=" + this.useNameWithoutRealm + ", ldapAuthenticationConfig=" + this.ldapAuthenticationConfig + ", keytabFile=" + this.keytabFile + ", principal=" + this.principal + ", getSkipIdentity()=" + this.getSkipIdentity() + ", getSkipEndpoint()=" + this.getSkipEndpoint() + ", getSkipRole()=" + this.getSkipRole() + "]";
    }

    @Override
    protected KerberosAuthenticationConfig self() {
        return this;
    }
}

