/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.scheduler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.exception.JobException;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.job.PipelineStatus;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalPlan;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalVertex;
import org.apache.seatunnel.engine.server.dag.physical.SubPlan;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.master.JobMaster;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.resource.ResourceProfile;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.scheduler.JobScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineBaseScheduler
implements JobScheduler {
    private static final Logger log = LoggerFactory.getLogger(PipelineBaseScheduler.class);
    private final PhysicalPlan physicalPlan;
    private final long jobId;
    private final JobMaster jobMaster;
    private final ResourceManager resourceManager;

    public PipelineBaseScheduler(@NonNull PhysicalPlan physicalPlan, @NonNull JobMaster jobMaster) {
        if (physicalPlan == null) {
            throw new NullPointerException("physicalPlan is marked @NonNull but is null");
        }
        if (jobMaster == null) {
            throw new NullPointerException("jobMaster is marked @NonNull but is null");
        }
        this.physicalPlan = physicalPlan;
        this.jobMaster = jobMaster;
        this.resourceManager = jobMaster.getResourceManager();
        this.jobId = physicalPlan.getJobImmutableInformation().getJobId();
    }

    @Override
    public void startScheduling() {
        if (this.physicalPlan.updateJobState(JobStatus.CREATED, JobStatus.SCHEDULED)) {
            List<CompletableFuture> collect2 = this.physicalPlan.getPipelineList().stream().map(pipeline -> this.schedulerPipeline((SubPlan)pipeline)).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                CompletableFuture<Void> voidCompletableFuture = CompletableFuture.allOf(collect2.toArray(new CompletableFuture[0]));
                voidCompletableFuture.get();
                this.physicalPlan.updateJobState(JobStatus.SCHEDULED, JobStatus.RUNNING);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (!JobStatus.CANCELED.equals((Object)this.physicalPlan.getJobStatus())) {
            throw new JobException(String.format("%s turn to a unexpected state: %s", new Object[]{this.physicalPlan.getJobFullName(), this.physicalPlan.getJobStatus()}));
        }
    }

    private CompletableFuture<Void> schedulerPipeline(SubPlan pipeline) {
        try {
            if (!pipeline.updatePipelineState(PipelineStatus.CREATED, PipelineStatus.SCHEDULED)) {
                this.handlePipelineStateTurnError(pipeline, PipelineStatus.SCHEDULED);
                return null;
            }
            Map<TaskGroupLocation, SlotProfile> slotProfiles = this.getOrApplyResourceForPipeline(pipeline, this.jobMaster.getOwnedSlotProfiles(pipeline.getPipelineLocation()));
            log.debug("slotProfiles: {}", (Object)slotProfiles);
            this.jobMaster.setOwnedSlotProfiles(pipeline.getPipelineLocation(), slotProfiles);
            return CompletableFuture.runAsync(() -> this.deployPipeline(pipeline, slotProfiles), this.jobMaster.getExecutorService());
        }
        catch (Exception e) {
            pipeline.cancelPipeline();
            return null;
        }
    }

    private Map<TaskGroupLocation, SlotProfile> getOrApplyResourceForPipeline(@NonNull SubPlan pipeline, Map<TaskGroupLocation, SlotProfile> ownedSlotProfiles) {
        if (pipeline == null) {
            throw new NullPointerException("pipeline is marked @NonNull but is null");
        }
        if (ownedSlotProfiles == null || ownedSlotProfiles.isEmpty()) {
            return this.applyResourceForPipeline(pipeline);
        }
        ConcurrentHashMap<TaskGroupLocation, SlotProfile> currentOwnedSlotProfiles = new ConcurrentHashMap<TaskGroupLocation, SlotProfile>();
        pipeline.getCoordinatorVertexList().forEach(coordinator -> currentOwnedSlotProfiles.put(coordinator.getTaskGroupLocation(), this.getOrApplyResourceForTask((PhysicalVertex)coordinator, ownedSlotProfiles)));
        pipeline.getPhysicalVertexList().forEach(task -> currentOwnedSlotProfiles.put(task.getTaskGroupLocation(), this.getOrApplyResourceForTask((PhysicalVertex)task, ownedSlotProfiles)));
        return currentOwnedSlotProfiles;
    }

    private SlotProfile getOrApplyResourceForTask(@NonNull PhysicalVertex task, Map<TaskGroupLocation, SlotProfile> ownedSlotProfiles) {
        if (task == null) {
            throw new NullPointerException("task is marked @NonNull but is null");
        }
        SlotProfile oldProfile = ownedSlotProfiles == null || ownedSlotProfiles.isEmpty() || ownedSlotProfiles.get(task.getTaskGroupLocation()) == null ? null : ownedSlotProfiles.get(task.getTaskGroupLocation());
        if (oldProfile == null || !this.resourceManager.slotActiveCheck(oldProfile)) {
            SlotProfile newProfile = this.applyResourceForTask(task).join();
            log.info(String.format("use new profile: %s to replace not active profile: %s for task %s", newProfile, oldProfile, task));
            return newProfile;
        }
        log.info(String.format("use active old profile: %s for task %s", oldProfile, task));
        task.updateTaskState(ExecutionState.CREATED, ExecutionState.SCHEDULED);
        return oldProfile;
    }

    private Map<TaskGroupLocation, SlotProfile> applyResourceForPipeline(@NonNull SubPlan subPlan) {
        if (subPlan == null) {
            throw new NullPointerException("subPlan is marked @NonNull but is null");
        }
        HashMap futures = new HashMap();
        HashMap<TaskGroupLocation, SlotProfile> slotProfiles = new HashMap<TaskGroupLocation, SlotProfile>();
        subPlan.getCoordinatorVertexList().forEach(coordinator -> futures.put(coordinator.getTaskGroupLocation(), this.applyResourceForTask((PhysicalVertex)coordinator)));
        subPlan.getPhysicalVertexList().forEach(task -> futures.put(task.getTaskGroupLocation(), this.applyResourceForTask((PhysicalVertex)task)));
        for (Map.Entry future : futures.entrySet()) {
            slotProfiles.put((TaskGroupLocation)future.getKey(), future.getValue() == null ? null : (SlotProfile)((CompletableFuture)future.getValue()).join());
        }
        return slotProfiles;
    }

    private CompletableFuture<SlotProfile> applyResourceForTask(PhysicalVertex task) {
        try {
            if (task.updateTaskState(ExecutionState.CREATED, ExecutionState.SCHEDULED)) {
                return this.resourceManager.applyResource(this.jobId, new ResourceProfile());
            }
            if (ExecutionState.CANCELING.equals(task.getExecutionState()) || ExecutionState.CANCELED.equals(task.getExecutionState())) {
                log.info("{} be canceled, skip {} this task.", (Object)task.getTaskFullName(), (Object)ExecutionState.SCHEDULED);
                return null;
            }
            this.makeTaskFailed(task.getTaskGroupLocation(), new JobException(String.format("%s turn to a unexpected state: %s, stop scheduler job.", task.getTaskFullName(), task.getExecutionState())));
            return null;
        }
        catch (Throwable e) {
            this.makeTaskFailed(task.getTaskGroupLocation(), e);
            return null;
        }
    }

    private CompletableFuture<Void> deployTask(PhysicalVertex task, SlotProfile slotProfile) {
        if (task.updateTaskState(ExecutionState.SCHEDULED, ExecutionState.DEPLOYING)) {
            return CompletableFuture.runAsync(() -> task.deploy(slotProfile));
        }
        if (ExecutionState.CANCELING.equals(task.getExecutionState()) || ExecutionState.CANCELED.equals(task.getExecutionState())) {
            log.info("{} be canceled, skip {} this task.", (Object)task.getTaskFullName(), (Object)ExecutionState.DEPLOYING);
            return null;
        }
        this.jobMaster.updateTaskExecutionState(new TaskExecutionState(task.getTaskGroupLocation(), ExecutionState.FAILED, new JobException(String.format("%s turn to a unexpected state: %s, stop scheduler job.", task.getTaskFullName(), task.getExecutionState()))));
        return null;
    }

    private void deployPipeline(@NonNull SubPlan pipeline, Map<TaskGroupLocation, SlotProfile> slotProfiles) {
        if (pipeline == null) {
            throw new NullPointerException("pipeline is marked @NonNull but is null");
        }
        if (pipeline.updatePipelineState(PipelineStatus.SCHEDULED, PipelineStatus.DEPLOYING)) {
            try {
                List<CompletableFuture> deployCoordinatorFuture = pipeline.getCoordinatorVertexList().stream().map(coordinator -> this.deployTask((PhysicalVertex)coordinator, (SlotProfile)slotProfiles.get(coordinator.getTaskGroupLocation()))).filter(Objects::nonNull).collect(Collectors.toList());
                List deployTaskFuture = pipeline.getPhysicalVertexList().stream().map(task -> this.deployTask((PhysicalVertex)task, (SlotProfile)slotProfiles.get(task.getTaskGroupLocation()))).filter(Objects::nonNull).collect(Collectors.toList());
                deployCoordinatorFuture.addAll(deployTaskFuture);
                CompletableFuture<Void> voidCompletableFuture = CompletableFuture.allOf(deployCoordinatorFuture.toArray(new CompletableFuture[0]));
                voidCompletableFuture.get();
                if (!pipeline.updatePipelineState(PipelineStatus.DEPLOYING, PipelineStatus.RUNNING)) {
                    log.info("{} turn to state {}, skip the running state.", (Object)pipeline.getPipelineFullName(), (Object)pipeline.getPipelineState());
                }
            }
            catch (Exception e) {
                this.makePipelineFailed(pipeline, e);
            }
        } else if (PipelineStatus.CANCELING.equals((Object)pipeline.getPipelineState()) || PipelineStatus.CANCELED.equals((Object)pipeline.getPipelineState())) {
            log.info("{} turn to state {}, skip {} this pipeline.", new Object[]{pipeline.getPipelineFullName(), pipeline.getPipelineState(), PipelineStatus.DEPLOYING});
        } else {
            this.makePipelineFailed(pipeline, new JobException(String.format("%s turn to a unexpected state: %s, stop scheduler job", new Object[]{pipeline.getPipelineFullName(), pipeline.getPipelineState()})));
        }
    }

    @Override
    public CompletableFuture<Void> reSchedulerPipeline(@NonNull SubPlan subPlan) {
        if (subPlan == null) {
            throw new NullPointerException("subPlan is marked @NonNull but is null");
        }
        return this.schedulerPipeline(subPlan);
    }

    private void handlePipelineStateTurnError(SubPlan pipeline, PipelineStatus targetState) {
        if (!PipelineStatus.CANCELING.equals((Object)pipeline.getPipelineState()) && !PipelineStatus.CANCELED.equals((Object)pipeline.getPipelineState())) {
            throw new JobException(String.format("%s turn to a unexpected state: %s, stop scheduler job", new Object[]{pipeline.getPipelineFullName(), pipeline.getPipelineState()}));
        }
        log.info("{} turn to state {}, skip {} this pipeline.", new Object[]{pipeline.getPipelineFullName(), pipeline.getPipelineState(), targetState});
    }

    private void makePipelineFailed(@NonNull SubPlan pipeline, Throwable e) {
        if (pipeline == null) {
            throw new NullPointerException("pipeline is marked @NonNull but is null");
        }
        pipeline.getCoordinatorVertexList().forEach(coordinator -> this.makeTaskFailed(coordinator.getTaskGroupLocation(), e));
        pipeline.getPhysicalVertexList().forEach(task -> this.makeTaskFailed(task.getTaskGroupLocation(), e));
    }

    private void makeTaskFailed(@NonNull TaskGroupLocation taskGroupLocation, Throwable e) {
        if (taskGroupLocation == null) {
            throw new NullPointerException("taskGroupLocation is marked @NonNull but is null");
        }
        this.jobMaster.updateTaskExecutionState(new TaskExecutionState(taskGroupLocation, ExecutionState.FAILED, e));
    }
}

