/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.metrics;

import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiFunction;
import org.apache.seatunnel.api.common.metrics.Metric;
import org.apache.seatunnel.api.common.metrics.Unit;
import org.apache.seatunnel.common.utils.SeaTunnelException;

public class MetricsContext
implements DynamicMetricsProvider {
    private static final BiFunction<String, Unit, AbstractMetric> CREATE_SINGLE_WRITER_METRIC = SingleWriterMetric::new;
    private static final BiFunction<String, Unit, AbstractMetric> CREATE_THREAD_SAFE_METRICS = ThreadSafeMetric::new;
    private static final BiFunction<String, Unit, AbstractMetric> CREATE_SINGLE_WRITER_QPS_METRIC = SingleWriterQPSMetric::new;
    private static final BiFunction<String, Unit, AbstractMetric> CREATE_THREAD_SAFE_QPS_METRIC = ThreadSafeQPSMetric::new;
    private volatile Map<String, AbstractMetric> metrics;

    public Metric metric(String name, Unit unit) {
        return this.metric(name, unit, CREATE_SINGLE_WRITER_METRIC);
    }

    public Metric qpsMetric(String name, Unit unit) {
        return this.metric(name, unit, CREATE_SINGLE_WRITER_QPS_METRIC);
    }

    public Metric threadSafeMetric(String name, Unit unit) {
        return this.metric(name, unit, CREATE_THREAD_SAFE_METRICS);
    }

    public Metric threadSafeQpsMetric(String name, Unit unit) {
        return this.metric(name, unit, CREATE_THREAD_SAFE_QPS_METRIC);
    }

    private Metric metric(String name, Unit unit, BiFunction<String, Unit, AbstractMetric> metricSupplier) {
        AbstractMetric metric;
        if (this.metrics == null) {
            this.metrics = new ConcurrentHashMap<String, AbstractMetric>();
        }
        if ((metric = this.metrics.get(name)) != null) {
            return metric;
        }
        metric = metricSupplier.apply(name, unit);
        this.metrics.put(name, metric);
        return metric;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor tagger, MetricsCollectionContext context) {
        if (this.metrics != null) {
            this.metrics.forEach((name, metric) -> {
                if (metric.get() instanceof Long) {
                    context.collect(tagger.copy(), (String)name, ProbeLevel.INFO, this.toProbeUnit(metric.unit()), (Long)metric.get());
                } else if (metric.get() instanceof Double) {
                    context.collect(tagger.copy(), (String)name, ProbeLevel.INFO, this.toProbeUnit(metric.unit()), (Double)metric.get());
                } else {
                    throw new SeaTunnelException("The value of Metric does not support " + metric.get().getClass().getSimpleName() + " data type");
                }
            });
        }
    }

    private ProbeUnit toProbeUnit(Unit unit) {
        return ProbeUnit.valueOf(unit.name());
    }

    private static final class ThreadSafeMetric
    extends AbstractMetric {
        private static final AtomicLongFieldUpdater<ThreadSafeMetric> VOLATILE_VALUE_UPDATER = AtomicLongFieldUpdater.newUpdater(ThreadSafeMetric.class, "value");
        private volatile long value;

        ThreadSafeMetric(String name, Unit unit) {
            super(name, unit);
        }

        @Override
        public void increment() {
            VOLATILE_VALUE_UPDATER.incrementAndGet(this);
        }

        @Override
        public void increment(long amount) {
            VOLATILE_VALUE_UPDATER.addAndGet(this, amount);
        }

        @Override
        public void decrement() {
            VOLATILE_VALUE_UPDATER.decrementAndGet(this);
        }

        @Override
        public void decrement(long amount) {
            VOLATILE_VALUE_UPDATER.addAndGet(this, -amount);
        }

        @Override
        public void set(long newValue) {
            VOLATILE_VALUE_UPDATER.set(this, newValue);
        }

        @Override
        protected Object get() {
            return VOLATILE_VALUE_UPDATER.get(this);
        }
    }

    private static final class SingleWriterMetric
    extends AbstractMetric {
        private static final AtomicLongFieldUpdater<SingleWriterMetric> VOLATILE_VALUE_UPDATER = AtomicLongFieldUpdater.newUpdater(SingleWriterMetric.class, "value");
        private volatile long value;

        SingleWriterMetric(String name, Unit unit) {
            super(name, unit);
        }

        @Override
        public void set(long newValue) {
            VOLATILE_VALUE_UPDATER.lazySet(this, newValue);
        }

        @Override
        public void increment() {
            VOLATILE_VALUE_UPDATER.lazySet(this, this.value + 1L);
        }

        @Override
        public void increment(long increment) {
            VOLATILE_VALUE_UPDATER.lazySet(this, this.value + increment);
        }

        @Override
        public void decrement() {
            VOLATILE_VALUE_UPDATER.lazySet(this, this.value - 1L);
        }

        @Override
        public void decrement(long decrement) {
            VOLATILE_VALUE_UPDATER.lazySet(this, this.value - decrement);
        }

        @Override
        protected Object get() {
            return this.value;
        }
    }

    private static final class ThreadSafeQPSMetric
    extends AbstractMetric {
        private static final AtomicLongFieldUpdater<ThreadSafeQPSMetric> VOLATILE_VALUE_UPDATER = AtomicLongFieldUpdater.newUpdater(ThreadSafeQPSMetric.class, "value");
        private volatile long value;
        private final long timestamp = System.currentTimeMillis();

        ThreadSafeQPSMetric(String name, Unit unit) {
            super(name, unit);
        }

        @Override
        public void increment() {
            VOLATILE_VALUE_UPDATER.incrementAndGet(this);
        }

        @Override
        public void increment(long amount) {
            VOLATILE_VALUE_UPDATER.addAndGet(this, amount);
        }

        @Override
        public void decrement() {
            VOLATILE_VALUE_UPDATER.decrementAndGet(this);
        }

        @Override
        public void decrement(long amount) {
            VOLATILE_VALUE_UPDATER.addAndGet(this, -amount);
        }

        @Override
        public void set(long newValue) {
            VOLATILE_VALUE_UPDATER.set(this, newValue);
        }

        @Override
        protected Object get() {
            long cost = System.currentTimeMillis() - this.timestamp;
            return (double)this.value * 1000.0 / (double)cost;
        }
    }

    private static final class SingleWriterQPSMetric
    extends AbstractMetric {
        private static final AtomicLongFieldUpdater<SingleWriterQPSMetric> VOLATILE_VALUE_UPDATER = AtomicLongFieldUpdater.newUpdater(SingleWriterQPSMetric.class, "value");
        private volatile long value;
        private final long timestamp = System.currentTimeMillis();

        SingleWriterQPSMetric(String name, Unit unit) {
            super(name, unit);
        }

        @Override
        public void set(long newValue) {
            VOLATILE_VALUE_UPDATER.lazySet(this, newValue);
        }

        @Override
        public void increment() {
            VOLATILE_VALUE_UPDATER.lazySet(this, this.value + 1L);
        }

        @Override
        public void increment(long increment) {
            VOLATILE_VALUE_UPDATER.lazySet(this, this.value + increment);
        }

        @Override
        public void decrement() {
            VOLATILE_VALUE_UPDATER.lazySet(this, this.value - 1L);
        }

        @Override
        public void decrement(long decrement) {
            VOLATILE_VALUE_UPDATER.lazySet(this, this.value - decrement);
        }

        @Override
        protected Object get() {
            long cost = System.currentTimeMillis() - this.timestamp;
            return (double)this.value * 1000.0 / (double)cost;
        }
    }

    private static abstract class AbstractMetric
    implements Metric {
        private final String name;
        private final Unit unit;

        AbstractMetric(String name, Unit unit) {
            this.name = name;
            this.unit = unit;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Unit unit() {
            return this.unit;
        }

        protected abstract Object get();
    }
}

