/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.utils;

import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.seatunnel.common.utils.function.ConsumerWithException;
import org.apache.seatunnel.common.utils.function.RunnableWithException;
import org.apache.seatunnel.common.utils.function.SupplierWithException;
import org.apache.seatunnel.engine.common.exception.JobDefineCheckException;
import org.apache.seatunnel.engine.common.exception.JobNotFoundException;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;

public final class ExceptionUtil {
    private static final List<ImmutableTriple<Integer, Class<? extends Throwable>, ClientExceptionFactory.ExceptionFactory>> EXCEPTIONS = Arrays.asList(new ImmutableTriple<Integer, Class<SeaTunnelEngineException>, ClientExceptionFactory.ExceptionFactory>(1000, SeaTunnelEngineException.class, SeaTunnelEngineException::new), new ImmutableTriple<Integer, Class<JobNotFoundException>, ClientExceptionFactory.ExceptionFactory>(1001, JobNotFoundException.class, JobNotFoundException::new), new ImmutableTriple<Integer, Class<JobDefineCheckException>, ClientExceptionFactory.ExceptionFactory>(1002, JobDefineCheckException.class, JobDefineCheckException::new));

    private ExceptionUtil() {
    }

    public static void registerSeaTunnelExceptions(@NonNull ClientExceptionFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked @NonNull but is null");
        }
        for (ImmutableTriple<Integer, Class<? extends Throwable>, ClientExceptionFactory.ExceptionFactory> exception : EXCEPTIONS) {
            factory.register((Integer)exception.left, (Class)exception.middle, (ClientExceptionFactory.ExceptionFactory)exception.right);
        }
    }

    @NonNull
    public static RuntimeException rethrow(@NonNull Throwable t) {
        if (t == null) {
            throw new NullPointerException("t is marked @NonNull but is null");
        }
        if (t instanceof Error) {
            if (t instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)t);
            }
            throw (Error)t;
        }
        throw ExceptionUtil.peeledAndUnchecked(t);
    }

    @NonNull
    private static RuntimeException peeledAndUnchecked(@NonNull Throwable t) {
        if (t == null) {
            throw new NullPointerException("t is marked @NonNull but is null");
        }
        if ((t = ExceptionUtil.peel(t)) instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new SeaTunnelEngineException(t);
    }

    public static Throwable peel(Throwable t) {
        while ((t instanceof CompletionException || t instanceof ExecutionException || t instanceof InvocationTargetException) && t.getCause() != null && t.getCause() != t) {
            t = t.getCause();
        }
        return t;
    }

    public static <T extends Exception> void sneakyThrow(Throwable t) throws T {
        throw (Exception)t;
    }

    public static void sneaky(RunnableWithException runnable) {
        try {
            runnable.run();
        }
        catch (Exception r) {
            ExceptionUtil.sneakyThrow(r);
        }
    }

    public static <T> void sneaky(ConsumerWithException<T> consumer, T t) {
        try {
            consumer.accept(t);
        }
        catch (Exception r) {
            ExceptionUtil.sneakyThrow(r);
        }
    }

    public static <R, E extends Throwable> R sneaky(SupplierWithException<R, E> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable r) {
            ExceptionUtil.sneakyThrow(r);
            throw new RuntimeException("Never throw here.");
        }
    }
}

