/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.loader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.seatunnel.engine.common.loader.SeatunnelBaseClassLoader;

public class SeatunnelChildFirstClassLoader
extends SeatunnelBaseClassLoader {
    private final String[] alwaysParentFirstPatterns;
    private static final String[] DEFAULT_PARENT_FIRST_PATTERNS = new String[]{"java.", "javax.xml", "org.xml", "org.w3c", "org.apache.hadoop", "scala.", "org.apache.seatunnel.", "javax.annotation.", "org.slf4j", "org.apache.log4j", "org.apache.logging", "org.apache.commons.logging"};

    public SeatunnelChildFirstClassLoader(List<URL> urls) {
        this(urls, DEFAULT_PARENT_FIRST_PATTERNS);
    }

    public SeatunnelChildFirstClassLoader(List<URL> urls, String[] alwaysParentFirstPatterns) {
        this(urls.toArray(new URL[0]), SeatunnelChildFirstClassLoader.class.getClassLoader(), alwaysParentFirstPatterns, NOOP_EXCEPTION_HANDLER);
    }

    public SeatunnelChildFirstClassLoader(URL[] urls, ClassLoader parent, String[] alwaysParentFirstPatterns, Consumer<Throwable> classLoadingExceptionHandler) {
        super(urls, parent, classLoadingExceptionHandler);
        this.alwaysParentFirstPatterns = alwaysParentFirstPatterns;
    }

    @Override
    protected synchronized Class<?> loadClassWithoutExceptionHandling(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            for (String alwaysParentFirstPattern : this.alwaysParentFirstPatterns) {
                if (!name.startsWith(alwaysParentFirstPattern)) continue;
                return super.loadClassWithoutExceptionHandling(name, resolve);
            }
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = super.loadClassWithoutExceptionHandling(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL urlClassLoaderResource = this.findResource(name);
        if (urlClassLoaderResource != null) {
            return urlClassLoaderResource;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urlClassLoaderResources = this.findResources(name);
        final ArrayList<URL> result2 = new ArrayList<URL>();
        while (urlClassLoaderResources.hasMoreElements()) {
            result2.add(urlClassLoaderResources.nextElement());
        }
        Enumeration<URL> parentResources = this.getParent().getResources(name);
        while (parentResources.hasMoreElements()) {
            result2.add(parentResources.nextElement());
        }
        return new Enumeration<URL>(){
            final Iterator<URL> iter;
            {
                this.iter = result2.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }
}

