/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config;

import com.hazelcast.internal.util.Preconditions;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;
import org.apache.seatunnel.engine.common.config.server.SlotServiceConfig;

public class EngineConfig {
    private int backupCount = ServerConfigOptions.BACKUP_COUNT.defaultValue();
    private int printExecutionInfoInterval = ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL.defaultValue();
    private SlotServiceConfig slotServiceConfig = ServerConfigOptions.SLOT_SERVICE.defaultValue();
    private CheckpointConfig checkpointConfig = ServerConfigOptions.CHECKPOINT.defaultValue();

    public void setBackupCount(int newBackupCount) {
        Preconditions.checkBackupCount(newBackupCount, 0);
        this.backupCount = newBackupCount;
    }

    public void setPrintExecutionInfoInterval(int printExecutionInfoInterval) {
        Preconditions.checkPositive(printExecutionInfoInterval, ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL + " must be > 0");
        this.printExecutionInfoInterval = printExecutionInfoInterval;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public int getPrintExecutionInfoInterval() {
        return this.printExecutionInfoInterval;
    }

    public SlotServiceConfig getSlotServiceConfig() {
        return this.slotServiceConfig;
    }

    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    public void setSlotServiceConfig(SlotServiceConfig slotServiceConfig) {
        this.slotServiceConfig = slotServiceConfig;
    }

    public void setCheckpointConfig(CheckpointConfig checkpointConfig) {
        this.checkpointConfig = checkpointConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EngineConfig)) {
            return false;
        }
        EngineConfig other = (EngineConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBackupCount() != other.getBackupCount()) {
            return false;
        }
        if (this.getPrintExecutionInfoInterval() != other.getPrintExecutionInfoInterval()) {
            return false;
        }
        SlotServiceConfig this$slotServiceConfig = this.getSlotServiceConfig();
        SlotServiceConfig other$slotServiceConfig = other.getSlotServiceConfig();
        if (this$slotServiceConfig == null ? other$slotServiceConfig != null : !((Object)this$slotServiceConfig).equals(other$slotServiceConfig)) {
            return false;
        }
        CheckpointConfig this$checkpointConfig = this.getCheckpointConfig();
        CheckpointConfig other$checkpointConfig = other.getCheckpointConfig();
        return !(this$checkpointConfig == null ? other$checkpointConfig != null : !((Object)this$checkpointConfig).equals(other$checkpointConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EngineConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getBackupCount();
        result2 = result2 * 59 + this.getPrintExecutionInfoInterval();
        SlotServiceConfig $slotServiceConfig = this.getSlotServiceConfig();
        result2 = result2 * 59 + ($slotServiceConfig == null ? 43 : ((Object)$slotServiceConfig).hashCode());
        CheckpointConfig $checkpointConfig = this.getCheckpointConfig();
        result2 = result2 * 59 + ($checkpointConfig == null ? 43 : ((Object)$checkpointConfig).hashCode());
        return result2;
    }

    public String toString() {
        return "EngineConfig(backupCount=" + this.getBackupCount() + ", printExecutionInfoInterval=" + this.getPrintExecutionInfoInterval() + ", slotServiceConfig=" + this.getSlotServiceConfig() + ", checkpointConfig=" + this.getCheckpointConfig() + ")";
    }
}

