/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.core.starter.command.AbstractCommandArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static Path getConfigPath(AbstractCommandArgs args) {
        FileUtils.checkNotNull(args, "args");
        FileUtils.checkNotNull(args.getDeployMode(), "deploy mode");
        switch (args.getDeployMode()) {
            case CLIENT: {
                return Paths.get(args.getConfigFile(), new String[0]);
            }
            case CLUSTER: {
                return Paths.get(FileUtils.getFileName(args.getConfigFile()), new String[0]);
            }
        }
        throw new IllegalArgumentException("Unsupported deploy mode: " + (Object)((Object)args.getDeployMode()));
    }

    public static void checkConfigExist(Path configFile) {
        if (!configFile.toFile().exists()) {
            String message = "Can't find config file: " + configFile;
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, message);
        }
    }

    private static String getFileName(String filePath) {
        FileUtils.checkNotNull(filePath, "file path");
        return filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1);
    }

    private static <T> void checkNotNull(T arg, String argName) {
        if (arg == null) {
            throw new IllegalArgumentException(argName + " cannot be null");
        }
    }
}

