/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import com.hazelcast.query.impl.PredicateBuilderImpl;
import com.hazelcast.query.impl.predicates.AndPredicate;
import com.hazelcast.query.impl.predicates.BetweenPredicate;
import com.hazelcast.query.impl.predicates.EqualPredicate;
import com.hazelcast.query.impl.predicates.FalsePredicate;
import com.hazelcast.query.impl.predicates.GreaterLessPredicate;
import com.hazelcast.query.impl.predicates.ILikePredicate;
import com.hazelcast.query.impl.predicates.InPredicate;
import com.hazelcast.query.impl.predicates.InstanceOfPredicate;
import com.hazelcast.query.impl.predicates.LikePredicate;
import com.hazelcast.query.impl.predicates.NotEqualPredicate;
import com.hazelcast.query.impl.predicates.NotPredicate;
import com.hazelcast.query.impl.predicates.OrPredicate;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;
import com.hazelcast.query.impl.predicates.PartitionPredicateImpl;
import com.hazelcast.query.impl.predicates.RegexPredicate;
import com.hazelcast.query.impl.predicates.SqlPredicate;
import com.hazelcast.query.impl.predicates.TruePredicate;
import java.util.Comparator;
import java.util.Map;

public final class Predicates {
    private Predicates() {
    }

    public static PredicateBuilder newPredicateBuilder() {
        return new PredicateBuilderImpl();
    }

    public static <K, V> Predicate<K, V> alwaysTrue() {
        return TruePredicate.INSTANCE;
    }

    public static <K, V> Predicate<K, V> alwaysFalse() {
        return FalsePredicate.INSTANCE;
    }

    public static <K, V> Predicate<K, V> instanceOf(Class klass) {
        return new InstanceOfPredicate(klass);
    }

    public static <K, V> Predicate<K, V> and(Predicate ... predicates) {
        return new AndPredicate(predicates);
    }

    public static <K, V> Predicate<K, V> not(Predicate predicate) {
        return new NotPredicate(predicate);
    }

    public static <K, V> Predicate<K, V> or(Predicate ... predicates) {
        return new OrPredicate(predicates);
    }

    public static <K, V> Predicate<K, V> notEqual(String attribute, Comparable value) {
        return new NotEqualPredicate(attribute, value);
    }

    public static <K, V> Predicate<K, V> equal(String attribute, Comparable value) {
        return new EqualPredicate(attribute, value);
    }

    public static <K, V> Predicate<K, V> like(String attribute, String pattern) {
        return new LikePredicate(attribute, pattern);
    }

    public static <K, V> Predicate<K, V> ilike(String attribute, String pattern) {
        return new ILikePredicate(attribute, pattern);
    }

    public static <K, V> Predicate<K, V> regex(String attribute, String pattern) {
        return new RegexPredicate(attribute, pattern);
    }

    public static <K, V> Predicate<K, V> greaterThan(String attribute, Comparable value) {
        return new GreaterLessPredicate(attribute, value, false, false);
    }

    public static <K, V> Predicate<K, V> greaterEqual(String attribute, Comparable value) {
        return new GreaterLessPredicate(attribute, value, true, false);
    }

    public static <K, V> Predicate<K, V> lessThan(String attribute, Comparable value) {
        return new GreaterLessPredicate(attribute, value, false, true);
    }

    public static <K, V> Predicate<K, V> lessEqual(String attribute, Comparable value) {
        return new GreaterLessPredicate(attribute, value, true, true);
    }

    public static <K, V> Predicate<K, V> between(String attribute, Comparable from2, Comparable to2) {
        return new BetweenPredicate(attribute, from2, to2);
    }

    public static <K, V> Predicate<K, V> in(String attribute, Comparable ... values) {
        return new InPredicate(attribute, values);
    }

    public static <K, V> Predicate<K, V> sql(String expression) {
        return new SqlPredicate(expression);
    }

    public static <K, V> PagingPredicate<K, V> pagingPredicate(int pageSize) {
        return new PagingPredicateImpl(pageSize);
    }

    public static <K, V> PagingPredicate<K, V> pagingPredicate(Predicate predicate, int pageSize) {
        return new PagingPredicateImpl(predicate, pageSize);
    }

    public static <K, V> PagingPredicate<K, V> pagingPredicate(Comparator<Map.Entry<K, V>> comparator, int pageSize) {
        return new PagingPredicateImpl<K, V>(comparator, pageSize);
    }

    public static <K, V> PagingPredicate<K, V> pagingPredicate(Predicate<K, V> predicate, Comparator<Map.Entry<K, V>> comparator, int pageSize) {
        return new PagingPredicateImpl<K, V>(predicate, comparator, pageSize);
    }

    public static <K, V> PartitionPredicate<K, V> partitionPredicate(Object partitionKey, Predicate<K, V> target) {
        return new PartitionPredicateImpl<K, V>(partitionKey, target);
    }
}

