/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.event.sequence;

import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.map.impl.querycache.event.sequence.DefaultPartitionSequencer;
import com.hazelcast.map.impl.querycache.event.sequence.PartitionSequencer;
import com.hazelcast.map.impl.querycache.event.sequence.SubscriberSequencerProvider;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultSubscriberSequencerProvider
implements SubscriberSequencerProvider {
    private static final ConstructorFunction<Integer, PartitionSequencer> PARTITION_SEQUENCER_CONSTRUCTOR = arg -> new DefaultPartitionSequencer();
    private final ConcurrentMap<Integer, PartitionSequencer> partitionSequences = new ConcurrentHashMap<Integer, PartitionSequencer>();

    @Override
    public boolean compareAndSetSequence(long expect, long update2, int partitionId) {
        PartitionSequencer sequence2 = this.getOrCreateSequence(partitionId);
        return sequence2.compareAndSetSequence(expect, update2);
    }

    @Override
    public long getSequence(int partitionId) {
        PartitionSequencer sequence2 = this.getOrCreateSequence(partitionId);
        return sequence2.getSequence();
    }

    @Override
    public void reset(int partitionId) {
        PartitionSequencer sequence2 = this.getOrCreateSequence(partitionId);
        sequence2.reset();
    }

    @Override
    public void resetAll() {
        for (PartitionSequencer partitionSequencer : this.partitionSequences.values()) {
            partitionSequencer.reset();
        }
    }

    private PartitionSequencer getOrCreateSequence(int partitionId) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.partitionSequences, partitionId, PARTITION_SEQUENCER_CONSTRUCTOR);
    }
}

