/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.iterator;

import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.LazyMapEntry;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class AbstractMapPartitionIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    protected IMap<K, V> map;
    protected final int fetchSize;
    protected final int partitionId;
    protected boolean prefetchValues;
    protected IterationPointer[] pointers;
    protected int index;
    protected int currentIndex = -1;
    protected List result;

    public AbstractMapPartitionIterator(IMap<K, V> map2, int fetchSize, int partitionId, boolean prefetchValues) {
        this.map = map2;
        this.fetchSize = fetchSize;
        this.partitionId = partitionId;
        this.prefetchValues = prefetchValues;
        this.resetPointers();
    }

    @Override
    public boolean hasNext() {
        return this.result != null && this.index < this.result.size() || this.advance();
    }

    @Override
    public Map.Entry<K, V> next() {
        if (this.hasNext()) {
            this.currentIndex = this.index++;
            Data keyData = this.getKey(this.currentIndex);
            Object value = this.getValue(this.currentIndex, keyData);
            return new LazyMapEntry(keyData, value, (InternalSerializationService)this.getSerializationService());
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.result == null || this.currentIndex < 0) {
            throw new IllegalStateException("Iterator.next() must be called before remove()!");
        }
        Data keyData = this.getKey(this.currentIndex);
        this.map.remove(keyData);
        this.currentIndex = -1;
    }

    protected boolean advance() {
        if (this.pointers[this.pointers.length - 1].getIndex() < 0) {
            this.resetPointers();
            return false;
        }
        this.result = this.fetch();
        if (this.result != null && this.result.size() > 0) {
            this.index = 0;
            return true;
        }
        return false;
    }

    private void resetPointers() {
        this.pointers = new IterationPointer[]{new IterationPointer(Integer.MAX_VALUE, -1)};
    }

    protected void setIterationPointers(List response, IterationPointer[] pointers) {
        if (response != null && response.size() > 0) {
            this.pointers = pointers;
        }
    }

    protected abstract List fetch();

    protected abstract SerializationService getSerializationService();

    private Data getKey(int index) {
        if (this.result != null) {
            if (this.prefetchValues) {
                Map.Entry entry = (Map.Entry)this.result.get(index);
                return (Data)entry.getKey();
            }
            return (Data)this.result.get(index);
        }
        return null;
    }

    private Object getValue(int index, Data keyData) {
        if (this.result != null) {
            if (this.prefetchValues) {
                Map.Entry entry = (Map.Entry)this.result.get(index);
                return entry.getValue();
            }
            return this.map.get(keyData);
        }
        return null;
    }
}

