/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.impl.CacheEntriesWithCursor;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.cache.impl.operation.CacheFetchEntriesOperation;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheIterateEntriesCodec;
import com.hazelcast.client.impl.protocol.codec.MapFetchEntriesCodec;
import com.hazelcast.client.impl.protocol.codec.MapFetchWithQueryCodec;
import com.hazelcast.client.impl.proxy.ClientMapProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.Address;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.iterator.AbstractCursor;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.query.QueryResultRow;
import com.hazelcast.map.impl.query.ResultSegment;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ReadMapOrCacheP<F extends CompletableFuture, B, R>
extends AbstractProcessor {
    private static final int MAX_PARALLEL_READ = 5;
    private static final int MAX_FETCH_SIZE = 2048;
    private final Reader<F, B, R> reader;
    private final int[] partitionIds;
    private final IterationPointer[][] readPointers;
    private final int maxParallelRead;
    private F[] readFutures;
    private List<R> currentBatch = Collections.emptyList();
    private int currentBatchPosition;
    private int currentPartitionIndex = -1;
    private int numCompletedPartitions;
    private int nextPartitionReadIndex;
    private int partitionReadCount;
    private Object pendingItem;

    private ReadMapOrCacheP(@Nonnull Reader<F, B, R> reader, @Nonnull int[] partitionIds) {
        this.reader = reader;
        this.partitionIds = partitionIds;
        this.maxParallelRead = Math.min(partitionIds.length, 5);
        this.readPointers = new IterationPointer[partitionIds.length][];
        Arrays.fill((Object[])this.readPointers, new IterationPointer[]{new IterationPointer(Integer.MAX_VALUE, -1)});
    }

    @Override
    public boolean complete() {
        if (this.readFutures == null) {
            this.initialRead();
        }
        while (this.emitResultSet()) {
            if (this.tryGetNextResultSet()) continue;
            return this.numCompletedPartitions == this.partitionIds.length;
        }
        return false;
    }

    private void initialRead() {
        this.readFutures = new CompletableFuture[this.partitionIds.length];
        for (int i = 0; i < this.maxParallelRead; ++i) {
            this.readFutures[i] = this.reader.readBatch(this.partitionIds[i], this.readPointers[i]);
        }
        this.nextPartitionReadIndex = this.maxParallelRead;
        this.partitionReadCount = this.maxParallelRead;
    }

    private boolean emitResultSet() {
        if (this.pendingItem != null && !this.tryEmit(this.pendingItem)) {
            return false;
        }
        this.pendingItem = null;
        while (this.currentBatchPosition < this.currentBatch.size()) {
            Object item;
            if ((item = this.reader.toObject(this.currentBatch.get(this.currentBatchPosition++))) == null || this.tryEmit(item)) continue;
            this.pendingItem = item;
            return false;
        }
        return true;
    }

    private boolean tryGetNextResultSet() {
        while (this.currentBatch.size() == this.currentBatchPosition && ++this.currentPartitionIndex < this.partitionIds.length) {
            IterationPointer[] partitionPointers = this.readPointers[this.currentPartitionIndex];
            if (this.isDone(partitionPointers)) {
                assert (this.readFutures[this.currentPartitionIndex] == null) : "future not null";
                continue;
            }
            F future = this.readFutures[this.currentPartitionIndex];
            if (future == null) {
                this.readNextPartition();
                continue;
            }
            if (!((CompletableFuture)future).isDone()) continue;
            B result2 = this.toBatchResult(future);
            this.readFutures[this.currentPartitionIndex] = null;
            --this.partitionReadCount;
            IterationPointer[] pointers = this.reader.toNextPointer(result2);
            this.currentBatch = this.reader.toRecordSet(result2);
            if (this.isDone(pointers)) {
                ++this.numCompletedPartitions;
            } else assert (!this.currentBatch.isEmpty()) : "empty but not terminal batch";
            this.currentBatchPosition = 0;
            this.readPointers[this.currentPartitionIndex] = pointers;
            this.readNextPartition();
        }
        if (this.currentPartitionIndex == this.partitionIds.length) {
            this.currentPartitionIndex = -1;
            return false;
        }
        return true;
    }

    private void readNextPartition() {
        if (this.partitionReadCount == this.maxParallelRead) {
            return;
        }
        if (this.nextPartitionReadIndex == this.partitionIds.length) {
            this.nextPartitionReadIndex = 0;
        }
        while (this.nextPartitionReadIndex < this.partitionIds.length) {
            IterationPointer[] pointers = this.readPointers[this.nextPartitionReadIndex];
            if (this.readFutures[this.nextPartitionReadIndex] != null || this.isDone(pointers)) {
                ++this.nextPartitionReadIndex;
                continue;
            }
            this.readFutures[this.nextPartitionReadIndex] = this.reader.readBatch(this.partitionIds[this.nextPartitionReadIndex], pointers);
            ++this.nextPartitionReadIndex;
            ++this.partitionReadCount;
            break;
        }
    }

    private boolean isDone(IterationPointer[] partitionPointers) {
        return partitionPointers[partitionPointers.length - 1].getIndex() < 0;
    }

    private B toBatchResult(F future) {
        B result2;
        try {
            result2 = this.reader.toBatchResult(future);
        }
        catch (ExecutionException e) {
            Throwable ex = ExceptionUtil.peel(e);
            if (ex instanceof HazelcastSerializationException) {
                throw new JetException("Serialization error when reading the map: are the key, value, predicate and projection classes visible to IMDG? You need to use User Code Deployment, adding the classes to JetConfig isn't enough", e);
            }
            throw ExceptionUtil.rethrow(ex);
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.rethrow(e);
        }
        return result2;
    }

    static class RemoteMapQueryReader
    extends Reader<ClientInvocationFuture, MapFetchWithQueryCodec.ResponseParameters, Data> {
        private final Predicate predicate;
        private final Projection projection;
        private final ClientMapProxy clientMapProxy;

        RemoteMapQueryReader(@Nonnull HazelcastInstance hzInstance, @Nonnull String mapName, @Nonnull Predicate predicate, @Nonnull Projection projection) {
            super(mapName, r -> IterationPointer.decodePointers(r.iterationPointers), r -> r.results);
            this.predicate = predicate;
            this.projection = projection;
            this.clientMapProxy = (ClientMapProxy)hzInstance.getMap(mapName);
            this.serializationService = this.clientMapProxy.getContext().getSerializationService();
        }

        @Override
        @Nonnull
        public ClientInvocationFuture readBatch(int partitionId, IterationPointer[] pointers) {
            ClientMessage request = MapFetchWithQueryCodec.encodeRequest(this.objectName, IterationPointer.encodePointers(pointers), 2048, this.serializationService.toData(this.projection), this.serializationService.toData(this.predicate));
            ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstanceImpl)this.clientMapProxy.getContext().getHazelcastInstance(), request, (Object)this.objectName, partitionId);
            return clientInvocation.invoke();
        }

        @Override
        @Nonnull
        public MapFetchWithQueryCodec.ResponseParameters toBatchResult(@Nonnull ClientInvocationFuture future) throws ExecutionException, InterruptedException {
            return MapFetchWithQueryCodec.decodeResponse((ClientMessage)future.get());
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Data data) {
            return this.serializationService.toObject(data);
        }
    }

    static class RemoteMapReader
    extends Reader<ClientInvocationFuture, MapFetchEntriesCodec.ResponseParameters, Map.Entry<Data, Data>> {
        private final ClientMapProxy clientMapProxy;

        RemoteMapReader(@Nonnull HazelcastInstance hzInstance, @Nonnull String mapName) {
            super(mapName, parameters -> IterationPointer.decodePointers(parameters.iterationPointers), parameters -> parameters.entries);
            this.clientMapProxy = (ClientMapProxy)hzInstance.getMap(mapName);
            this.serializationService = this.clientMapProxy.getContext().getSerializationService();
        }

        @Override
        @Nonnull
        public ClientInvocationFuture readBatch(int partitionId, IterationPointer[] pointers) {
            ClientMessage request = MapFetchEntriesCodec.encodeRequest(this.objectName, IterationPointer.encodePointers(pointers), 2048);
            ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstanceImpl)this.clientMapProxy.getContext().getHazelcastInstance(), request, (Object)this.objectName, partitionId);
            return clientInvocation.invoke();
        }

        @Override
        @Nonnull
        public MapFetchEntriesCodec.ResponseParameters toBatchResult(@Nonnull ClientInvocationFuture future) throws ExecutionException, InterruptedException {
            return MapFetchEntriesCodec.decodeResponse((ClientMessage)future.get());
        }

        @Nullable
        public Map.Entry<Data, Data> toObject(@Nonnull Map.Entry<Data, Data> entry) {
            return new LazyMapEntry<Data, Data>(entry.getKey(), entry.getValue(), this.serializationService);
        }
    }

    static class LocalMapQueryReader
    extends Reader<InternalCompletableFuture<ResultSegment>, ResultSegment, QueryResultRow> {
        private final Predicate predicate;
        private final Projection projection;
        private final MapProxyImpl mapProxyImpl;

        LocalMapQueryReader(@Nonnull HazelcastInstance hzInstance, @Nonnull InternalSerializationService serializationService, @Nonnull String mapName, @Nonnull Predicate predicate, @Nonnull Projection projection) {
            super(mapName, ResultSegment::getPointers, segment -> ((QueryResult)segment.getResult()).getRows());
            this.predicate = predicate;
            this.projection = projection;
            this.mapProxyImpl = (MapProxyImpl)hzInstance.getMap(mapName);
            this.serializationService = serializationService;
        }

        @Override
        @Nonnull
        public InternalCompletableFuture<ResultSegment> readBatch(int partitionId, IterationPointer[] pointers) {
            MapOperationProvider operationProvider = this.mapProxyImpl.getOperationProvider();
            MapOperation op = operationProvider.createFetchWithQueryOperation(this.objectName, pointers, 2048, Query.of().mapName(this.objectName).iterationType(IterationType.VALUE).predicate(this.predicate).projection(this.projection).build());
            return this.mapProxyImpl.getOperationService().invokeOnPartition(this.mapProxyImpl.getServiceName(), op, partitionId);
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull QueryResultRow record) {
            return this.serializationService.toObject(record.getValue());
        }
    }

    static class LocalMapReader
    extends Reader<CompletableFuture<MapEntriesWithCursor>, MapEntriesWithCursor, Map.Entry<Data, Data>> {
        private static final int RETRY_DELAY = 100;
        private final MapProxyImpl mapProxyImpl;
        private final MapServiceContext mapServiceContext;
        private final NodeEngineImpl nodeEngine;
        private final boolean isHD;

        LocalMapReader(@Nonnull HazelcastInstance hzInstance, @Nonnull InternalSerializationService serializationService, @Nonnull String mapName) {
            super(mapName, AbstractCursor::getIterationPointers, AbstractCursor::getBatch);
            this.serializationService = serializationService;
            this.mapProxyImpl = (MapProxyImpl)hzInstance.getMap(mapName);
            this.nodeEngine = Util.getNodeEngine(hzInstance);
            MapService service = (MapService)this.nodeEngine.getService("hz:impl:mapService");
            this.mapServiceContext = service.getMapServiceContext();
            this.isHD = this.mapProxyImpl.getMapConfig().getInMemoryFormat().equals((Object)InMemoryFormat.NATIVE);
        }

        @Override
        @Nonnull
        public CompletableFuture<MapEntriesWithCursor> readBatch(int partitionId, IterationPointer[] pointers) {
            if (this.isHD) {
                return this.readWithOperationService(partitionId, pointers);
            }
            CompletableFuture<MapEntriesWithCursor> f = new CompletableFuture<MapEntriesWithCursor>();
            this.read0(f, partitionId, pointers);
            return f;
        }

        private void read0(CompletableFuture<MapEntriesWithCursor> f, int partitionId, IterationPointer[] pointers) {
            try {
                boolean isOwned = this.mapServiceContext.getOrInitCachedMemberPartitions().contains(partitionId);
                if (isOwned) {
                    int migrationStamp = this.mapServiceContext.getService().getMigrationStamp();
                    MapEntriesWithCursor result2 = this.readFromRecordStore(partitionId, pointers);
                    if (this.validateMigrationStamp(migrationStamp)) {
                        f.complete(result2);
                    } else {
                        this.scheduleForLater(f, partitionId, pointers);
                    }
                } else {
                    CompletableFuture<MapEntriesWithCursor> f1 = this.readWithOperationService(partitionId, pointers);
                    f1.whenComplete((r, t) -> {
                        if (t != null) {
                            f.completeExceptionally((Throwable)t);
                        } else {
                            f.complete((MapEntriesWithCursor)r);
                        }
                    });
                }
            }
            catch (Throwable t2) {
                f.completeExceptionally(t2);
            }
        }

        private void scheduleForLater(CompletableFuture<MapEntriesWithCursor> f, int partitionId, IterationPointer[] pointers) {
            this.nodeEngine.getExecutionService().schedule(() -> this.read0(f, partitionId, pointers), 100L, TimeUnit.MILLISECONDS);
        }

        private MapEntriesWithCursor readFromRecordStore(int partitionId, IterationPointer[] pointers) {
            PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
            RecordStore recordStore = partitionContainer.getExistingRecordStore(this.mapProxyImpl.getName());
            if (recordStore != null) {
                return recordStore.fetchEntries(pointers, 2048);
            }
            return new MapEntriesWithCursor((List<Map.Entry<Data, Data>>)new ArrayList<Map.Entry<Data, Data>>(), new IterationPointer[]{new IterationPointer(-1, -1)});
        }

        private CompletableFuture<MapEntriesWithCursor> readWithOperationService(int partitionId, IterationPointer[] pointers) {
            MapOperationProvider operationProvider = this.mapProxyImpl.getOperationProvider();
            MapOperation op = operationProvider.createFetchEntriesOperation(this.objectName, pointers, 2048);
            return this.mapProxyImpl.getOperationService().invokeOnPartition(this.mapProxyImpl.getServiceName(), op, partitionId);
        }

        private boolean validateMigrationStamp(int migrationStamp) {
            return this.mapServiceContext.getService().validateMigrationStamp(migrationStamp);
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Map.Entry<Data, Data> dataEntry) {
            return new LazyMapEntry(dataEntry.getKey(), dataEntry.getValue(), this.serializationService);
        }
    }

    static class RemoteCacheReader
    extends Reader<ClientInvocationFuture, CacheIterateEntriesCodec.ResponseParameters, Map.Entry<Data, Data>> {
        private final ClientCacheProxy clientCacheProxy;

        RemoteCacheReader(@Nonnull HazelcastInstance hzInstance, @Nonnull String cacheName) {
            super(cacheName, parameters -> IterationPointer.decodePointers(parameters.iterationPointers), parameters -> parameters.entries);
            this.clientCacheProxy = (ClientCacheProxy)hzInstance.getCacheManager().getCache(cacheName);
            this.serializationService = this.clientCacheProxy.getContext().getSerializationService();
        }

        @Override
        @Nonnull
        public ClientInvocationFuture readBatch(int partitionId, IterationPointer[] pointers) {
            String name = this.clientCacheProxy.getPrefixedName();
            ClientMessage request = CacheIterateEntriesCodec.encodeRequest(name, IterationPointer.encodePointers(pointers), 2048);
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientCacheProxy.getContext().getHazelcastInstance();
            return new ClientInvocation(client, request, (Object)name, partitionId).invoke();
        }

        @Override
        @Nonnull
        public CacheIterateEntriesCodec.ResponseParameters toBatchResult(@Nonnull ClientInvocationFuture future) throws ExecutionException, InterruptedException {
            return CacheIterateEntriesCodec.decodeResponse((ClientMessage)future.get());
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Map.Entry<Data, Data> dataEntry) {
            return new LazyMapEntry(dataEntry.getKey(), dataEntry.getValue(), this.serializationService);
        }
    }

    static class LocalCacheReader
    extends Reader<InternalCompletableFuture<CacheEntriesWithCursor>, CacheEntriesWithCursor, Map.Entry<Data, Data>> {
        private final CacheProxy cacheProxy;

        LocalCacheReader(@Nonnull HazelcastInstance hzInstance, @Nonnull InternalSerializationService serializationService, @Nonnull String cacheName) {
            super(cacheName, CacheEntriesWithCursor::getPointers, CacheEntriesWithCursor::getEntries);
            this.cacheProxy = (CacheProxy)hzInstance.getCacheManager().getCache(cacheName);
            this.serializationService = serializationService;
        }

        @Override
        @Nonnull
        public InternalCompletableFuture<CacheEntriesWithCursor> readBatch(int partitionId, IterationPointer[] pointers) {
            CacheFetchEntriesOperation op = new CacheFetchEntriesOperation(this.cacheProxy.getPrefixedName(), pointers, 2048);
            OperationService operationService = this.cacheProxy.getOperationService();
            return operationService.invokeOnPartition(this.cacheProxy.getServiceName(), op, partitionId);
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Map.Entry<Data, Data> dataEntry) {
            return new LazyMapEntry(dataEntry.getKey(), dataEntry.getValue(), this.serializationService);
        }
    }

    static abstract class Reader<F extends CompletableFuture, B, R> {
        protected final String objectName;
        protected InternalSerializationService serializationService;
        private final FunctionEx<B, IterationPointer[]> toNextIterationPointerFn;
        private FunctionEx<B, List<R>> toRecordSetFn;

        Reader(@Nonnull String objectName, @Nonnull FunctionEx<B, IterationPointer[]> toNextIterationPointerFn, @Nonnull FunctionEx<B, List<R>> toRecordSetFn) {
            this.objectName = objectName;
            this.toNextIterationPointerFn = toNextIterationPointerFn;
            this.toRecordSetFn = toRecordSetFn;
        }

        @Nonnull
        abstract F readBatch(int var1, IterationPointer[] var2);

        @Nonnull
        B toBatchResult(@Nonnull F future) throws ExecutionException, InterruptedException {
            return (B)((CompletableFuture)future).get();
        }

        final IterationPointer[] toNextPointer(@Nonnull B result2) {
            return this.toNextIterationPointerFn.apply(result2);
        }

        @Nonnull
        final List<R> toRecordSet(@Nonnull B result2) {
            return this.toRecordSetFn.apply(result2);
        }

        @Nullable
        abstract Object toObject(@Nonnull R var1);
    }

    static class RemoteProcessorSupplier<F extends CompletableFuture, B, R>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final String clientXml;
        private final FunctionEx<HazelcastInstance, Reader<F, B, R>> readerSupplier;
        private transient HazelcastClientProxy client;
        private transient int totalParallelism;
        private transient int baseIndex;

        RemoteProcessorSupplier(@Nonnull String clientXml, @Nonnull FunctionEx<HazelcastInstance, Reader<F, B, R>> readerSupplier) {
            this.clientXml = clientXml;
            this.readerSupplier = readerSupplier;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.client = (HazelcastClientProxy)HazelcastClient.newHazelcastClient(ImdgUtil.asClientConfig(this.clientXml));
            this.totalParallelism = context.totalParallelism();
            this.baseIndex = context.memberIndex() * context.localParallelism();
        }

        @Override
        public void close(Throwable error) {
            if (this.client != null) {
                this.client.shutdown();
            }
        }

        @Nonnull
        public List<Processor> get(int count2) {
            int remotePartitionCount = this.client.client.getClientPartitionService().getPartitionCount();
            return IntStream.range(0, count2).mapToObj(i -> {
                int[] partitionIds = Util.roundRobinPart(remotePartitionCount, this.totalParallelism, this.baseIndex + i);
                return new ReadMapOrCacheP(this.readerSupplier.apply(this.client), partitionIds);
            }).collect(Collectors.toList());
        }
    }

    private static final class LocalProcessorSupplier<F extends CompletableFuture, B, R>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final BiFunction<HazelcastInstance, InternalSerializationService, Reader<F, B, R>> readerSupplier;
        private transient int[] memberPartitions;
        private transient HazelcastInstance hzInstance;
        private transient InternalSerializationService serializationService;

        private LocalProcessorSupplier(@Nonnull BiFunction<HazelcastInstance, InternalSerializationService, Reader<F, B, R>> readerSupplier) {
            this.readerSupplier = readerSupplier;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.hzInstance = context.hazelcastInstance();
            this.serializationService = ((Contexts.ProcSupplierCtx)context).serializationService();
            this.memberPartitions = context.partitionAssignment().get(this.hzInstance.getCluster().getLocalMember().getAddress());
        }

        @Nonnull
        public List<Processor> get(int count2) {
            return Arrays.stream(Util.distributeObjects(count2, this.memberPartitions)).map(partitions -> new ReadMapOrCacheP(this.readerSupplier.apply(this.hzInstance, this.serializationService), (int[])partitions)).collect(Collectors.toList());
        }
    }

    static abstract class LocalProcessorMetaSupplier<F extends CompletableFuture, B, R>
    implements ProcessorMetaSupplier {
        private static final long serialVersionUID = 1L;
        private final BiFunctionEx<HazelcastInstance, InternalSerializationService, Reader<F, B, R>> readerSupplier;

        LocalProcessorMetaSupplier(@Nonnull BiFunctionEx<HazelcastInstance, InternalSerializationService, Reader<F, B, R>> readerSupplier) {
            this.readerSupplier = readerSupplier;
        }

        @Nonnull
        public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            return address -> new LocalProcessorSupplier(this.readerSupplier);
        }

        @Override
        public int preferredLocalParallelism() {
            return 1;
        }

        @Override
        public abstract Permission getRequiredPermission();
    }
}

