/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.serialization.impl.portable.DefaultPortableReader;
import com.hazelcast.internal.serialization.impl.portable.PortableSerializer;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.Portable;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MorphingPortableReader
extends DefaultPortableReader {
    public MorphingPortableReader(PortableSerializer serializer, BufferObjectDataInput in, ClassDefinition cd) {
        super(serializer, in, cd);
    }

    @Override
    public int readInt(@Nonnull String fieldName) throws IOException {
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            return 0;
        }
        switch (fd.getType()) {
            case INT: {
                return super.readInt(fieldName);
            }
            case BYTE: {
                return super.readByte(fieldName);
            }
            case CHAR: {
                return super.readChar(fieldName);
            }
            case SHORT: {
                return super.readShort(fieldName);
            }
        }
        throw this.createIncompatibleClassChangeError(fd, FieldType.INT);
    }

    @Override
    public long readLong(@Nonnull String fieldName) throws IOException {
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            return 0L;
        }
        switch (fd.getType()) {
            case LONG: {
                return super.readLong(fieldName);
            }
            case INT: {
                return super.readInt(fieldName);
            }
            case BYTE: {
                return super.readByte(fieldName);
            }
            case CHAR: {
                return super.readChar(fieldName);
            }
            case SHORT: {
                return super.readShort(fieldName);
            }
        }
        throw this.createIncompatibleClassChangeError(fd, FieldType.LONG);
    }

    @Override
    @Nullable
    public String readUTF(@Nonnull String fieldName) throws IOException {
        return this.readString(fieldName);
    }

    @Override
    @Nullable
    public String readString(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.UTF, x$0 -> super.readString((String)x$0));
    }

    @Override
    public boolean readBoolean(@Nonnull String fieldName) throws IOException {
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            return false;
        }
        this.validateTypeCompatibility(fd, FieldType.BOOLEAN);
        return super.readBoolean(fieldName);
    }

    @Override
    public byte readByte(@Nonnull String fieldName) throws IOException {
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            return 0;
        }
        this.validateTypeCompatibility(fd, FieldType.BYTE);
        return super.readByte(fieldName);
    }

    @Override
    public char readChar(@Nonnull String fieldName) throws IOException {
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            return '\u0000';
        }
        this.validateTypeCompatibility(fd, FieldType.CHAR);
        return super.readChar(fieldName);
    }

    @Override
    public double readDouble(@Nonnull String fieldName) throws IOException {
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            return 0.0;
        }
        switch (fd.getType()) {
            case DOUBLE: {
                return super.readDouble(fieldName);
            }
            case LONG: {
                return super.readLong(fieldName);
            }
            case FLOAT: {
                return super.readFloat(fieldName);
            }
            case INT: {
                return super.readInt(fieldName);
            }
            case BYTE: {
                return super.readByte(fieldName);
            }
            case CHAR: {
                return super.readChar(fieldName);
            }
            case SHORT: {
                return super.readShort(fieldName);
            }
        }
        throw this.createIncompatibleClassChangeError(fd, FieldType.DOUBLE);
    }

    @Override
    public float readFloat(@Nonnull String fieldName) throws IOException {
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            return 0.0f;
        }
        switch (fd.getType()) {
            case FLOAT: {
                return super.readFloat(fieldName);
            }
            case INT: {
                return super.readInt(fieldName);
            }
            case BYTE: {
                return super.readByte(fieldName);
            }
            case CHAR: {
                return super.readChar(fieldName);
            }
            case SHORT: {
                return super.readShort(fieldName);
            }
        }
        throw this.createIncompatibleClassChangeError(fd, FieldType.FLOAT);
    }

    @Override
    public short readShort(@Nonnull String fieldName) throws IOException {
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            return 0;
        }
        switch (fd.getType()) {
            case SHORT: {
                return super.readShort(fieldName);
            }
            case BYTE: {
                return super.readByte(fieldName);
            }
        }
        throw this.createIncompatibleClassChangeError(fd, FieldType.SHORT);
    }

    @Override
    @Nullable
    public BigDecimal readDecimal(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.DECIMAL, x$0 -> super.readDecimal((String)x$0));
    }

    @Override
    @Nullable
    public LocalTime readTime(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.TIME, x$0 -> super.readTime((String)x$0));
    }

    @Override
    @Nullable
    public LocalDate readDate(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.DATE, x$0 -> super.readDate((String)x$0));
    }

    @Override
    @Nullable
    public LocalDateTime readTimestamp(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.TIMESTAMP, x$0 -> super.readTimestamp((String)x$0));
    }

    @Override
    @Nullable
    public OffsetDateTime readTimestampWithTimezone(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE, x$0 -> super.readTimestampWithTimezone((String)x$0));
    }

    @Override
    @Nullable
    public byte[] readByteArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.BYTE_ARRAY, x$0 -> super.readByteArray((String)x$0));
    }

    @Override
    @Nullable
    public boolean[] readBooleanArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.BOOLEAN_ARRAY, x$0 -> super.readBooleanArray((String)x$0));
    }

    @Override
    @Nullable
    public char[] readCharArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.CHAR_ARRAY, x$0 -> super.readCharArray((String)x$0));
    }

    @Override
    @Nullable
    public int[] readIntArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.INT_ARRAY, x$0 -> super.readIntArray((String)x$0));
    }

    @Override
    @Nullable
    public long[] readLongArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.LONG_ARRAY, x$0 -> super.readLongArray((String)x$0));
    }

    @Override
    @Nullable
    public double[] readDoubleArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.DOUBLE_ARRAY, x$0 -> super.readDoubleArray((String)x$0));
    }

    @Override
    @Nullable
    public float[] readFloatArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.FLOAT_ARRAY, x$0 -> super.readFloatArray((String)x$0));
    }

    @Override
    @Nullable
    public short[] readShortArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.SHORT_ARRAY, x$0 -> super.readShortArray((String)x$0));
    }

    @Override
    @Nullable
    public String[] readUTFArray(@Nonnull String fieldName) throws IOException {
        return this.readStringArray(fieldName);
    }

    @Override
    @Nullable
    public String[] readStringArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.UTF_ARRAY, x$0 -> super.readStringArray((String)x$0));
    }

    @Override
    @Nullable
    public Portable readPortable(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.PORTABLE, x$0 -> super.readPortable((String)x$0));
    }

    @Override
    @Nullable
    public Portable[] readPortableArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.PORTABLE_ARRAY, x$0 -> super.readPortableArray((String)x$0));
    }

    @Override
    @Nullable
    public BigDecimal[] readDecimalArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.DECIMAL_ARRAY, x$0 -> super.readDecimalArray((String)x$0));
    }

    @Override
    @Nullable
    public LocalTime[] readTimeArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.TIME_ARRAY, x$0 -> super.readTimeArray((String)x$0));
    }

    @Override
    @Nullable
    public LocalDate[] readDateArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.DATE_ARRAY, x$0 -> super.readDateArray((String)x$0));
    }

    @Override
    @Nullable
    public LocalDateTime[] readTimestampArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.TIMESTAMP_ARRAY, x$0 -> super.readTimestampArray((String)x$0));
    }

    @Override
    @Nullable
    public OffsetDateTime[] readTimestampWithTimezoneArray(@Nonnull String fieldName) throws IOException {
        return this.readIncompatibleField(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY, x$0 -> super.readTimestampWithTimezoneArray((String)x$0));
    }

    private <T> T readIncompatibleField(@Nonnull String fieldName, FieldType fieldType, DefaultPortableReader.Reader<String, T> reader) throws IOException {
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            return null;
        }
        this.validateTypeCompatibility(fd, fieldType);
        return reader.read(fieldName);
    }

    private void validateTypeCompatibility(FieldDefinition fd, FieldType expectedType) {
        if (fd.getType() != expectedType) {
            throw this.createIncompatibleClassChangeError(fd, expectedType);
        }
    }

    private IncompatibleClassChangeError createIncompatibleClassChangeError(FieldDefinition fd, FieldType expectedType) {
        return new IncompatibleClassChangeError("Incompatible to read " + (Object)((Object)expectedType) + " from " + (Object)((Object)fd.getType()) + " while reading field: " + fd.getName() + " on " + this.cd);
    }
}

