/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.common.serialization;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.translation.serialization.RowConverter;
import org.apache.seatunnel.translation.spark.common.utils.InstantConverterUtils;
import org.apache.seatunnel.translation.spark.common.utils.TypeConverterUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.MutableAny;
import org.apache.spark.sql.catalyst.expressions.MutableBoolean;
import org.apache.spark.sql.catalyst.expressions.MutableByte;
import org.apache.spark.sql.catalyst.expressions.MutableDouble;
import org.apache.spark.sql.catalyst.expressions.MutableFloat;
import org.apache.spark.sql.catalyst.expressions.MutableInt;
import org.apache.spark.sql.catalyst.expressions.MutableLong;
import org.apache.spark.sql.catalyst.expressions.MutableShort;
import org.apache.spark.sql.catalyst.expressions.MutableValue;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

public final class InternalRowConverter
extends RowConverter<InternalRow> {
    public InternalRowConverter(SeaTunnelDataType<?> dataType) {
        super(dataType);
    }

    @Override
    public InternalRow convert(SeaTunnelRow seaTunnelRow) throws IOException {
        this.validate(seaTunnelRow);
        return (InternalRow)InternalRowConverter.convert((Object)seaTunnelRow, this.dataType);
    }

    private static Object convert(Object field2, SeaTunnelDataType<?> dataType) {
        if (field2 == null) {
            return null;
        }
        switch (dataType.getSqlType()) {
            case ROW: {
                SeaTunnelRow seaTunnelRow = (SeaTunnelRow)field2;
                SeaTunnelRowType rowType = (SeaTunnelRowType)dataType;
                return InternalRowConverter.convert(seaTunnelRow, rowType);
            }
            case DATE: {
                return (int)((LocalDate)field2).toEpochDay();
            }
            case TIME: {
                throw new RuntimeException("time type is not supported now, but will be supported in the future.");
            }
            case TIMESTAMP: {
                return InstantConverterUtils.toEpochMicro(Timestamp.valueOf((LocalDateTime)field2).toInstant());
            }
            case MAP: {
                return InternalRowConverter.convertMap((Map)field2, (MapType)dataType);
            }
            case STRING: {
                return UTF8String.fromString((String)((String)field2));
            }
            case DECIMAL: {
                return Decimal.apply((BigDecimal)((BigDecimal)field2));
            }
            case ARRAY: {
                if (((ArrayType)dataType).getElementType().equals(BasicType.STRING_TYPE)) {
                    String[] fields = (String[])field2;
                    Object[] objects = Arrays.stream(fields).map(UTF8String::fromString).toArray();
                    return ArrayData.toArrayData((Object)objects);
                }
                return ArrayData.toArrayData((Object)field2);
            }
        }
        return field2;
    }

    private static InternalRow convert(SeaTunnelRow seaTunnelRow, SeaTunnelRowType rowType) {
        int arity = rowType.getTotalFields();
        MutableValue[] values = new MutableValue[arity];
        for (int i = 0; i < arity; ++i) {
            values[i] = InternalRowConverter.createMutableValue(rowType.getFieldType(i));
            if ("op".equals(rowType.getFieldName(i))) {
                values[i].update((Object)seaTunnelRow.getRowKind().toByteValue());
                continue;
            }
            Object fieldValue = InternalRowConverter.convert(seaTunnelRow.getField(i), rowType.getFieldType(i));
            if (fieldValue == null) continue;
            values[i].update(fieldValue);
        }
        return new SpecificInternalRow(values);
    }

    private static ArrayBasedMapData convertMap(Map<?, ?> mapData, MapType<?, ?> mapType) {
        if (mapData == null || mapData.size() == 0) {
            return ArrayBasedMapData.apply((Object)new Object[0], (Object)new Object[0]);
        }
        SeaTunnelDataType<?> keyType = mapType.getKeyType();
        SeaTunnelDataType<?> valueType = mapType.getValueType();
        HashMap newMap = new HashMap(mapData.size());
        mapData.forEach((key, value) -> newMap.put(InternalRowConverter.convert(key, keyType), InternalRowConverter.convert(value, valueType)));
        Object[] keys = newMap.keySet().toArray();
        Object[] values = newMap.values().toArray();
        return ArrayBasedMapData.apply((Object)keys, (Object)values);
    }

    private static Map<Object, Object> reconvertMap(MapData mapData, MapType<?, ?> mapType) {
        if (mapData == null || mapData.numElements() == 0) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> newMap = new HashMap<Object, Object>(mapData.numElements());
        int num = mapData.numElements();
        SeaTunnelDataType<?> keyType = mapType.getKeyType();
        SeaTunnelDataType<?> valueType = mapType.getValueType();
        Object[] keys = mapData.keyArray().toObjectArray(TypeConverterUtils.convert(keyType));
        Object[] values = mapData.valueArray().toObjectArray(TypeConverterUtils.convert(valueType));
        for (int i = 0; i < num; ++i) {
            keys[i] = InternalRowConverter.reconvert(keys[i], keyType);
            values[i] = InternalRowConverter.reconvert(values[i], valueType);
            newMap.put(keys[i], values[i]);
        }
        return newMap;
    }

    private static MutableValue createMutableValue(SeaTunnelDataType<?> dataType) {
        switch (dataType.getSqlType()) {
            case BOOLEAN: {
                return new MutableBoolean();
            }
            case TINYINT: {
                return new MutableByte();
            }
            case SMALLINT: {
                return new MutableShort();
            }
            case DATE: 
            case INT: {
                return new MutableInt();
            }
            case TIMESTAMP: 
            case BIGINT: {
                return new MutableLong();
            }
            case FLOAT: {
                return new MutableFloat();
            }
            case DOUBLE: {
                return new MutableDouble();
            }
        }
        return new MutableAny();
    }

    @Override
    public SeaTunnelRow reconvert(InternalRow engineRow) throws IOException {
        return (SeaTunnelRow)InternalRowConverter.reconvert((Object)engineRow, this.dataType);
    }

    private static Object reconvert(Object field2, SeaTunnelDataType<?> dataType) {
        if (field2 == null) {
            return null;
        }
        switch (dataType.getSqlType()) {
            case ROW: {
                return InternalRowConverter.reconvert((InternalRow)field2, (SeaTunnelRowType)dataType);
            }
            case DATE: {
                return LocalDate.ofEpochDay(((Integer)field2).intValue());
            }
            case TIME: {
                throw new RuntimeException("SeaTunnel not support time type, it will be supported in the future.");
            }
            case TIMESTAMP: {
                return Timestamp.from(InstantConverterUtils.ofEpochMicro((Long)field2)).toLocalDateTime();
            }
            case MAP: {
                return InternalRowConverter.reconvertMap((MapData)field2, (MapType)dataType);
            }
            case STRING: {
                return field2.toString();
            }
            case DECIMAL: {
                return ((Decimal)field2).toJavaBigDecimal();
            }
            case ARRAY: {
                return InternalRowConverter.reconvertArray((ArrayData)field2, (ArrayType)dataType);
            }
        }
        return field2;
    }

    private static SeaTunnelRow reconvert(InternalRow engineRow, SeaTunnelRowType rowType) {
        Object[] fields = new Object[engineRow.numFields()];
        for (int i = 0; i < engineRow.numFields(); ++i) {
            fields[i] = InternalRowConverter.reconvert(engineRow.get(i, TypeConverterUtils.convert(rowType.getFieldType(i))), rowType.getFieldType(i));
        }
        return new SeaTunnelRow(fields);
    }

    private static Object reconvertArray(ArrayData arrayData, ArrayType<?, ?> arrayType) {
        if (arrayData == null || arrayData.numElements() == 0) {
            return Collections.emptyList().toArray();
        }
        Object[] newArray = new Object[arrayData.numElements()];
        Object[] values = arrayData.toObjectArray(TypeConverterUtils.convert(arrayType.getElementType()));
        for (int i = 0; i < arrayData.numElements(); ++i) {
            newArray[i] = InternalRowConverter.reconvert(values[i], arrayType.getElementType());
        }
        return newArray;
    }
}

