/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.flow;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.api.transform.Collector;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.engine.core.dag.actions.TransformChainAction;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointBarrier;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.flow.ActionFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.OneInputFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class TransformFlowLifeCycle<T>
extends ActionFlowLifeCycle
implements OneInputFlowLifeCycle<Record<?>> {
    private final TransformChainAction<T> action;
    private final List<SeaTunnelTransform<T>> transform;
    private final Collector<Record<?>> collector;

    public TransformFlowLifeCycle(TransformChainAction<T> action, SeaTunnelTask runningTask, Collector<Record<?>> collector, CompletableFuture<Void> completableFuture) {
        super(action, runningTask, completableFuture);
        this.action = action;
        this.transform = action.getTransforms();
        this.collector = collector;
    }

    @Override
    public void received(Record<?> record) {
        if (record.getData() instanceof Barrier) {
            CheckpointBarrier barrier = (CheckpointBarrier)record.getData();
            if (barrier.prepareClose()) {
                this.prepareClose = true;
            }
            if (barrier.snapshot()) {
                this.runningTask.addState(barrier, this.action.getId(), Collections.emptyList());
            }
            this.runningTask.ack(barrier);
            this.collector.collect(record);
        } else {
            if (this.prepareClose.booleanValue()) {
                return;
            }
            Object r = record.getData();
            for (SeaTunnelTransform<?> seaTunnelTransform : this.transform) {
                r = seaTunnelTransform.map(r);
            }
            this.collector.collect(new Record(r));
        }
    }

    @Override
    public void restoreState(List<ActionSubtaskState> actionStateList) throws Exception {
    }
}

