/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.checkpoint.storage.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class StorageThreadFactory
implements ThreadFactory {
    private final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public StorageThreadFactory() {
        SecurityManager s2 = System.getSecurityManager();
        this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "StorageThread-" + this.poolNumber.getAndIncrement() + "-thread-";
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }
}

