/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.map.IMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nonnull;

public class IMapInputStream
extends InputStream {
    private final IMap<String, byte[]> map;
    private final String prefix;
    private final int chunkCount;
    private ByteBuffer currentChunk;
    private int currentChunkIndex;

    public IMapInputStream(IMap<String, byte[]> map2, String prefix) {
        this.map = map2;
        this.prefix = prefix;
        byte[] encodedChunkCount = Objects.requireNonNull(map2.get(prefix), "A file/directory with id '" + prefix + "' wasn't attached");
        this.chunkCount = ByteBuffer.wrap(encodedChunkCount).getInt();
    }

    @Override
    public void close() throws IOException {
        this.currentChunk = null;
        this.currentChunkIndex = -1;
    }

    private boolean isClosed() {
        return this.currentChunkIndex < 0;
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        if ((len | off) < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException(String.format("b.length == %,d, off == %,d, len == %,d", b.length, off, len));
        }
        if (this.isClosed()) {
            throw new IOException("Stream already closed");
        }
        try {
            int countToGet;
            if (this.currentChunkIndex == 0 && !this.fetchNextChunk()) {
                return -1;
            }
            int readCount = 0;
            do {
                countToGet = Math.min(len - readCount, this.currentChunk.remaining());
                this.currentChunk.get(b, off + readCount, countToGet);
            } while ((readCount += countToGet) < len && this.fetchNextChunk());
            return readCount > 0 ? readCount : -1;
        }
        catch (Exception e) {
            throw new IOException("Reading chunked IMap failed: " + e, e);
        }
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("Single-byte read not implemented");
    }

    private boolean fetchNextChunk() {
        if (this.currentChunkIndex == this.chunkCount) {
            return false;
        }
        this.currentChunk = ByteBuffer.wrap(this.map.get(this.prefix + '_' + this.currentChunkIndex));
        ++this.currentChunkIndex;
        return true;
    }
}

