/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.compact.AbstractGenericRecordBuilder;
import com.hazelcast.internal.serialization.impl.compact.DeserializedGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.SchemaWriter;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class DeserializedGenericRecordBuilder
extends AbstractGenericRecordBuilder {
    private final TreeMap<String, Object> objects = new TreeMap();
    private final SchemaWriter schemaWriter;

    public DeserializedGenericRecordBuilder(String typeName) {
        this.schemaWriter = new SchemaWriter(typeName);
    }

    @Override
    @Nonnull
    public GenericRecord build() {
        return new DeserializedGenericRecord(this.schemaWriter.build(), this.objects);
    }

    @Override
    protected GenericRecordBuilder write(@Nonnull String fieldName, Object value, FieldKind fieldKind) {
        if (this.objects.putIfAbsent(fieldName, value) != null) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        this.schemaWriter.addField(new FieldDescriptor(fieldName, fieldKind));
        return this;
    }
}

