/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.impl.CachedProbe;
import com.hazelcast.internal.metrics.impl.MetricDescriptorImpl;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.impl.ProbeUtils;
import com.hazelcast.internal.metrics.impl.SourceMetadata;
import com.hazelcast.internal.util.counters.Counter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Semaphore;

abstract class FieldProbe
implements ProbeFunction {
    final CachedProbe probe;
    final Field field;
    final int type;
    final SourceMetadata sourceMetadata;
    final String probeName;

    FieldProbe(Field field2, Probe probe, int type, SourceMetadata sourceMetadata) {
        this.field = field2;
        this.probe = new CachedProbe(probe);
        this.type = type;
        this.sourceMetadata = sourceMetadata;
        this.probeName = probe.name();
        assert (this.probeName != null);
        assert (this.probeName.length() > 0);
        field2.setAccessible(true);
    }

    void register(MetricsRegistryImpl metricsRegistry, Object source, String namePrefix) {
        MetricDescriptorImpl descriptor = metricsRegistry.newMetricDescriptor().withPrefix(namePrefix).withMetric(this.getProbeName());
        metricsRegistry.registerInternal(source, descriptor, this.probe.level(), this);
    }

    void register(MetricsRegistryImpl metricsRegistry, MetricDescriptor descriptor, Object source) {
        metricsRegistry.registerStaticProbe(source, descriptor, this.getProbeName(), this.probe.level(), this.probe.unit(), this);
    }

    String getProbeName() {
        return this.probeName;
    }

    static <S> FieldProbe createFieldProbe(Field field2, Probe probe, SourceMetadata sourceMetadata) {
        int type = ProbeUtils.getType(field2.getType());
        if (type == -1) {
            throw new IllegalArgumentException(String.format("@Probe field '%s' is of an unhandled type", field2));
        }
        if (ProbeUtils.isDouble(type)) {
            return new DoubleFieldProbe(field2, probe, type, sourceMetadata);
        }
        return new LongFieldProbe(field2, probe, type, sourceMetadata);
    }

    static class DoubleFieldProbe<S>
    extends FieldProbe
    implements DoubleProbeFunction<S> {
        DoubleFieldProbe(Field field2, Probe probe, int type, SourceMetadata sourceMetadata) {
            super(field2, probe, type, sourceMetadata);
        }

        @Override
        public double get(S source) throws Exception {
            switch (this.type) {
                case 3: {
                    return this.field.getDouble(source);
                }
                case 4: {
                    Number doubleNumber = (Number)this.field.get(source);
                    return doubleNumber == null ? 0.0 : doubleNumber.doubleValue();
                }
            }
            throw new IllegalStateException("Unhandled type:" + this.type);
        }
    }

    static class LongFieldProbe<S>
    extends FieldProbe
    implements LongProbeFunction<S> {
        LongFieldProbe(Field field2, Probe probe, int type, SourceMetadata sourceMetadata) {
            super(field2, probe, type, sourceMetadata);
        }

        @Override
        public long get(S source) throws Exception {
            switch (this.type) {
                case 1: {
                    return this.field.getLong(source);
                }
                case 2: {
                    Number longNumber = (Number)this.field.get(source);
                    return longNumber == null ? 0L : longNumber.longValue();
                }
                case 6: {
                    Map map2 = (Map)this.field.get(source);
                    return map2 == null ? 0L : (long)map2.size();
                }
                case 5: {
                    Collection collection = (Collection)this.field.get(source);
                    return collection == null ? 0L : (long)collection.size();
                }
                case 7: {
                    Counter counter = (Counter)this.field.get(source);
                    return counter == null ? 0L : counter.get();
                }
                case 8: {
                    Semaphore semaphore = (Semaphore)this.field.get(source);
                    return semaphore == null ? 0L : (long)semaphore.availablePermits();
                }
            }
            throw new IllegalStateException("Unhandled type:" + this.type);
        }
    }
}

