/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class TransactionCreateCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1376768;
    public static final int RESPONSE_MESSAGE_TYPE = 1376769;
    private static final int REQUEST_TIMEOUT_FIELD_OFFSET = 16;
    private static final int REQUEST_DURABILITY_FIELD_OFFSET = 24;
    private static final int REQUEST_TRANSACTION_TYPE_FIELD_OFFSET = 28;
    private static final int REQUEST_THREAD_ID_FIELD_OFFSET = 32;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 40;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 30;

    private TransactionCreateCodec() {
    }

    public static ClientMessage encodeRequest(long timeout, int durability, int transactionType, long threadId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Transaction.Create");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[40], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1376768);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, timeout);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, durability);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 28, transactionType);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 32, threadId);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.timeout = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.durability = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.transactionType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 28);
        request.threadId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 32);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1376769);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static UUID decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator2.next();
        return FixedSizeTypesCodec.decodeUUID(initialFrame.content, 13);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public long timeout;
        public int durability;
        public int transactionType;
        public long threadId;
    }
}

