/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompressionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressionUtils.class);

    private CompressionUtils() {
    }

    public static void tarGzip(final Path inputDir, Path outputFile) throws IOException {
        LOGGER.info("Tar directory '{}' to file '{}'.", (Object)inputDir, (Object)outputFile);
        try (OutputStream out = Files.newOutputStream(outputFile, new OpenOption[0]);
             BufferedOutputStream bufferedOut = new BufferedOutputStream(out);
             GzipCompressorOutputStream gzOut = new GzipCompressorOutputStream(bufferedOut);
             final TarArchiveOutputStream tarOut = new TarArchiveOutputStream(gzOut);){
            Files.walkFileTree(inputDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isSymbolicLink()) {
                        return FileVisitResult.CONTINUE;
                    }
                    String fileName = inputDir.relativize(path).toString();
                    TarArchiveEntry archiveEntry = new TarArchiveEntry(path.toFile(), fileName);
                    tarOut.putArchiveEntry(archiveEntry);
                    Files.copy(path, tarOut);
                    tarOut.closeArchiveEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
            tarOut.finish();
            LOGGER.info("Creating tar file '{}'.", (Object)outputFile);
        }
        catch (IOException e) {
            LOGGER.error("Error when tar directory '{}' to file '{}'.", (Object)inputDir, (Object)outputFile);
            throw e;
        }
    }

    public static void unTar(File inputFile, File outputDir) throws IOException, ArchiveException {
        LOGGER.info("Untaring {} to dir {}.", (Object)inputFile.getAbsolutePath(), (Object)outputDir.getAbsolutePath());
        LinkedList<File> untaredFiles = new LinkedList<File>();
        try (FileInputStream is = new FileInputStream(inputFile);
             TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", is);){
            TarArchiveEntry entry = null;
            while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                File outputFile = new File(outputDir, entry.getName());
                if (!outputFile.toPath().normalize().startsWith(outputDir.toPath())) {
                    throw new IllegalStateException("Bad zip entry");
                }
                if (entry.isDirectory()) {
                    LOGGER.info("Attempting to write output directory {}.", (Object)outputFile.getAbsolutePath());
                    if (!outputFile.exists()) {
                        LOGGER.info("Attempting to create output directory {}.", (Object)outputFile.getAbsolutePath());
                        if (!outputFile.mkdirs()) {
                            throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                        }
                    }
                } else {
                    LOGGER.info("Creating output file {}.", (Object)outputFile.getAbsolutePath());
                    FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                    IOUtils.copy(debInputStream, outputFileStream);
                    ((OutputStream)outputFileStream).close();
                }
                untaredFiles.add(outputFile);
            }
        }
    }

    public static File unGzip(File inputFile, File outputDir) throws IOException {
        LOGGER.info("Unzipping {} to dir {}.", (Object)inputFile.getAbsolutePath(), (Object)outputDir.getAbsolutePath());
        File outputFile = new File(outputDir, inputFile.getName().substring(0, inputFile.getName().length() - 3));
        try (FileInputStream fis = new FileInputStream(inputFile);
             GZIPInputStream in = new GZIPInputStream(fis);
             FileOutputStream out = new FileOutputStream(outputFile);){
            IOUtils.copy(in, out);
        }
        return outputFile;
    }
}

