/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.seatunnel.common.config.ConfigRuntimeException;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.command.CommandArgs;
import org.apache.seatunnel.core.starter.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Seatunnel {
    private static final Logger LOGGER = LoggerFactory.getLogger(Seatunnel.class);

    public static <T extends CommandArgs> void run(Command<T> command) throws CommandException {
        try {
            command.execute();
        }
        catch (ConfigRuntimeException e) {
            Seatunnel.showConfigError(e);
            throw e;
        }
        catch (Exception e) {
            Seatunnel.showFatalError(e);
            throw e;
        }
    }

    private static void showConfigError(Throwable throwable) {
        LOGGER.error("\n\n===============================================================================\n\n");
        String errorMsg = throwable.getMessage();
        LOGGER.error("Config Error:\n");
        LOGGER.error("Reason: {} \n", (Object)errorMsg);
        LOGGER.error("\n===============================================================================\n\n\n");
    }

    private static void showFatalError(Throwable throwable) {
        LOGGER.error("\n\n===============================================================================\n\n");
        String errorMsg = throwable.getMessage();
        LOGGER.error("Fatal Error, \n");
        LOGGER.error("Please submit bug report in https://github.com/apache/incubator-seatunnel/issues\n");
        LOGGER.error("Reason:{} \n", (Object)errorMsg);
        LOGGER.error("Exception StackTrace:{} ", (Object)ExceptionUtils.getStackTrace(throwable));
        LOGGER.error("\n===============================================================================\n\n\n");
    }
}

